/*
 * Decompiled with CFR 0.152.
 */
package com.epam.ta.reportportal.ws.resolver;

import com.epam.ta.reportportal.commons.querygen.CompositeFilter;
import com.epam.ta.reportportal.commons.querygen.Filter;
import com.epam.ta.reportportal.commons.querygen.Queryable;
import com.epam.ta.reportportal.commons.validation.BusinessRule;
import com.epam.ta.reportportal.core.filter.predefined.PredefinedFilterType;
import com.epam.ta.reportportal.core.filter.predefined.PredefinedFilters;
import com.epam.ta.reportportal.ws.model.ErrorType;
import com.epam.ta.reportportal.ws.resolver.FilterFor;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import org.jooq.Operator;
import org.springframework.core.MethodParameter;
import org.springframework.web.bind.support.WebDataBinderFactory;
import org.springframework.web.context.request.NativeWebRequest;
import org.springframework.web.method.support.HandlerMethodArgumentResolver;
import org.springframework.web.method.support.ModelAndViewContainer;

public class PredefinedFilterCriteriaResolver
implements HandlerMethodArgumentResolver {
    public static final String PREDEFINED_FILTER_PREFIX = "predefinedFilter.";

    public boolean supportsParameter(MethodParameter methodParameter) {
        return Queryable.class.isAssignableFrom(methodParameter.getParameterType()) && null != methodParameter.getParameterAnnotation(FilterFor.class);
    }

    public Queryable resolveArgument(MethodParameter methodParameter, ModelAndViewContainer paramModelAndViewContainer, NativeWebRequest webRequest, WebDataBinderFactory paramWebDataBinderFactory) {
        Class<?> domainModelType = ((FilterFor)methodParameter.getParameterAnnotation(FilterFor.class)).value();
        List filterConditions = webRequest.getParameterMap().entrySet().stream().filter(parameter -> ((String)parameter.getKey()).startsWith(PREDEFINED_FILTER_PREFIX)).map(parameter -> {
            BusinessRule.expect(parameter.getValue(), v -> null != v && ((String[])v).length == 1).verify(ErrorType.INCORRECT_REQUEST, new Object[]{"Incorrect filter value"});
            String filterName = ((String)parameter.getKey()).split("\\.")[1];
            String[] filterParameters = ((String[])parameter.getValue())[0].split(",");
            Optional<PredefinedFilterType> predefinedFilterType = PredefinedFilterType.fromString(filterName);
            BusinessRule.expect(predefinedFilterType, Optional::isPresent).verify(ErrorType.BAD_REQUEST_ERROR, new Object[]{"Incorrect predefined filter type " + filterName});
            BusinessRule.expect((Object)PredefinedFilters.hasFilter(predefinedFilterType.get()), Predicate.isEqual(true)).verify(ErrorType.INCORRECT_REQUEST, new Object[]{"Unknown filter '" + filterName + "'"});
            Queryable queryable = PredefinedFilters.buildFilter(predefinedFilterType.get(), filterParameters);
            BusinessRule.expect((Object)queryable.getTarget().getClazz(), Predicate.isEqual(domainModelType)).verify(ErrorType.INCORRECT_REQUEST, new Object[]{"Incorrect filter target class type"});
            return queryable;
        }).collect(Collectors.toList());
        return filterConditions.isEmpty() ? this.nop(domainModelType) : new CompositeFilter(Operator.AND, filterConditions);
    }

    private Queryable nop(Class<?> type) {
        return new Filter(type, Collections.emptyList());
    }
}

