/*
 * Decompiled with CFR 0.152.
 */
package com.epam.ta.reportportal.ws.converter.converters;

import com.epam.ta.reportportal.entity.statistics.Statistics;
import com.epam.ta.reportportal.ws.model.statistics.StatisticsResource;
import java.util.Optional;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;

public final class StatisticsConverter {
    public static final Function<Set<Statistics>, StatisticsResource> TO_RESOURCE = statistics -> {
        StatisticsResource statisticsResource = new StatisticsResource();
        statisticsResource.setDefects(statistics.stream().filter(it -> Optional.ofNullable(it.getStatisticsField()).isPresent() && StringUtils.isNotEmpty((CharSequence)it.getStatisticsField().getName())).filter(it -> it.getCounter() > 0 && it.getStatisticsField().getName().contains("defects")).collect(Collectors.groupingBy(it -> it.getStatisticsField().getName().split("\\$")[2], Collectors.groupingBy(it -> it.getStatisticsField().getName().split("\\$")[3], Collectors.summingInt(Statistics::getCounter)))));
        statisticsResource.setExecutions(statistics.stream().filter(it -> Optional.ofNullable(it.getStatisticsField()).isPresent() && StringUtils.isNotEmpty((CharSequence)it.getStatisticsField().getName())).filter(it -> it.getCounter() > 0 && it.getStatisticsField().getName().contains("executions")).collect(Collectors.groupingBy(it -> it.getStatisticsField().getName().split("\\$")[2], Collectors.summingInt(Statistics::getCounter))));
        return statisticsResource;
    };

    private StatisticsConverter() {
    }
}

