/*
 * Decompiled with CFR 0.152.
 */
package com.epam.ta.reportportal.ws.converter.converters;

import com.epam.ta.reportportal.commons.EntityUtils;
import com.epam.ta.reportportal.entity.enums.LogLevel;
import com.epam.ta.reportportal.entity.log.Log;
import com.epam.ta.reportportal.ws.model.log.LogResource;
import com.epam.ta.reportportal.ws.model.log.SearchLogRs;
import com.google.common.base.Preconditions;
import java.util.Date;
import java.util.Optional;
import java.util.function.Function;
import org.apache.commons.lang3.StringUtils;

public final class LogConverter {
    public static final Function<Log, LogResource> TO_RESOURCE = model -> {
        Preconditions.checkNotNull((Object)model);
        LogResource resource = new LogResource();
        resource.setId(model.getId());
        resource.setUuid(model.getUuid());
        resource.setMessage(Optional.ofNullable(model.getLogMessage()).orElse("NULL"));
        resource.setLogTime((Date)EntityUtils.TO_DATE.apply(model.getLogTime()));
        if (LogConverter.isBinaryDataExists(model)) {
            LogResource.BinaryContent binaryContent = new LogResource.BinaryContent();
            binaryContent.setBinaryDataId(String.valueOf(model.getAttachment().getId()));
            binaryContent.setContentType(model.getAttachment().getContentType());
            binaryContent.setThumbnailId(model.getAttachment().getThumbnailId());
            resource.setBinaryContent(binaryContent);
        }
        Optional.ofNullable(model.getTestItem()).ifPresent(testItem -> resource.setItemId(testItem.getItemId()));
        Optional.ofNullable(model.getLaunch()).ifPresent(launch -> resource.setLaunchId(launch.getId()));
        Optional.ofNullable(model.getLogLevel()).ifPresent(level -> resource.setLevel(LogLevel.toLevel((int)level).toString()));
        return resource;
    };
    public static final Function<Log, SearchLogRs.LogEntry> TO_LOG_ENTRY = log -> {
        SearchLogRs.LogEntry logEntry = new SearchLogRs.LogEntry();
        logEntry.setMessage(log.getLogMessage());
        logEntry.setLevel(LogLevel.toLevel((int)log.getLogLevel()).name());
        return logEntry;
    };

    private LogConverter() {
    }

    private static boolean isBinaryDataExists(Log log) {
        return Optional.ofNullable(log.getAttachment()).map(a -> StringUtils.isNotEmpty((CharSequence)a.getContentType()) || StringUtils.isNotEmpty((CharSequence)a.getThumbnailId()) || StringUtils.isNotEmpty((CharSequence)a.getFileId())).orElse(false);
    }
}

