/*
 * Decompiled with CFR 0.152.
 */
package com.epam.ta.reportportal.ws.converter.converters;

import com.epam.ta.reportportal.commons.EntityUtils;
import com.epam.ta.reportportal.entity.activity.Activity;
import com.epam.ta.reportportal.ws.model.ActivityResource;
import java.util.Date;
import java.util.Optional;
import java.util.function.BiFunction;
import java.util.function.Function;

public final class ActivityConverter {
    public static final Function<Activity, ActivityResource> TO_RESOURCE = activity -> {
        ActivityResource resource = new ActivityResource();
        resource.setId(activity.getId());
        resource.setLastModified((Date)EntityUtils.TO_DATE.apply(activity.getCreatedAt()));
        resource.setObjectType(activity.getActivityEntityType());
        resource.setActionType(activity.getAction());
        resource.setProjectId(activity.getProjectId());
        resource.setUser(activity.getUsername());
        Optional.ofNullable(activity.getObjectId()).ifPresent(arg_0 -> ((ActivityResource)resource).setLoggedObjectId(arg_0));
        resource.setDetails((Object)activity.getDetails());
        return resource;
    };
    public static final BiFunction<Activity, String, ActivityResource> TO_RESOURCE_WITH_USER = (activity, username) -> {
        ActivityResource resource = TO_RESOURCE.apply((Activity)activity);
        resource.setUser(username);
        return resource;
    };

    private ActivityConverter() {
    }
}

