/*
 * Decompiled with CFR 0.152.
 */
package com.epam.ta.reportportal.ws.converter.builders;

import com.epam.ta.reportportal.commons.querygen.Condition;
import com.epam.ta.reportportal.commons.querygen.FilterCondition;
import com.epam.ta.reportportal.entity.filter.FilterSort;
import com.epam.ta.reportportal.entity.filter.ObjectType;
import com.epam.ta.reportportal.entity.filter.UserFilter;
import com.epam.ta.reportportal.entity.project.Project;
import com.epam.ta.reportportal.exception.ReportPortalException;
import com.epam.ta.reportportal.ws.model.ErrorType;
import com.epam.ta.reportportal.ws.model.filter.Order;
import com.epam.ta.reportportal.ws.model.filter.UpdateUserFilterRQ;
import com.epam.ta.reportportal.ws.model.filter.UserFilterCondition;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import org.springframework.data.domain.Sort;

public class UserFilterBuilder
implements Supplier<UserFilter> {
    private UserFilter userFilter;

    public UserFilterBuilder() {
        this.userFilter = new UserFilter();
    }

    public UserFilterBuilder(UserFilter userFilter) {
        this.userFilter = userFilter;
    }

    public UserFilterBuilder addFilterRq(UpdateUserFilterRQ rq) {
        this.userFilter.setDescription(rq.getDescription());
        Optional.ofNullable(rq.getName()).ifPresent(it -> this.userFilter.setName(it));
        Optional.ofNullable(rq.getObjectType()).ifPresent(it -> this.userFilter.setTargetClass(ObjectType.getObjectTypeByName((String)rq.getObjectType())));
        Optional.ofNullable(rq.getShare()).ifPresent(it -> this.userFilter.setShared(it.booleanValue()));
        this.addFilterConditions(rq.getConditions());
        this.addSelectionParameters(rq.getOrders());
        return this;
    }

    public UserFilterBuilder addFilterConditions(Set<UserFilterCondition> conditions) {
        this.userFilter.getFilterCondition().clear();
        Optional.ofNullable(conditions).ifPresent(c -> this.userFilter.getFilterCondition().addAll(c.stream().map(entity -> FilterCondition.builder().withSearchCriteria(entity.getFilteringField()).withValue(entity.getValue()).withNegative(Condition.isNegative((String)entity.getCondition())).withCondition((Condition)Condition.findByMarker((String)entity.getCondition()).orElseThrow(() -> new ReportPortalException(ErrorType.INCORRECT_REQUEST, new Object[]{entity.getCondition()}))).build()).collect(Collectors.toList())));
        return this;
    }

    public UserFilterBuilder addSelectionParameters(List<Order> orders) {
        this.userFilter.getFilterSorts().clear();
        Optional.ofNullable(orders).ifPresent(o -> o.forEach(order -> {
            FilterSort filterSort = new FilterSort();
            filterSort.setField(order.getSortingColumnName());
            filterSort.setDirection(order.getIsAsc() ? Sort.Direction.ASC : Sort.Direction.DESC);
            this.userFilter.getFilterSorts().add(filterSort);
        }));
        return this;
    }

    public UserFilterBuilder addProject(Long projectId) {
        Project project = new Project();
        project.setId(projectId);
        this.userFilter.setProject(project);
        return this;
    }

    public UserFilterBuilder addOwner(String owner) {
        this.userFilter.setOwner(owner);
        return this;
    }

    @Override
    public UserFilter get() {
        return this.userFilter;
    }
}

