/*
 * Decompiled with CFR 0.152.
 */
package com.epam.ta.reportportal.ws.controller;

import com.epam.ta.reportportal.commons.EntityUtils;
import com.epam.ta.reportportal.commons.ReportPortalUser;
import com.epam.ta.reportportal.core.project.settings.CreateProjectSettingsHandler;
import com.epam.ta.reportportal.core.project.settings.DeleteProjectSettingsHandler;
import com.epam.ta.reportportal.core.project.settings.GetProjectSettingsHandler;
import com.epam.ta.reportportal.core.project.settings.UpdateProjectSettingsHandler;
import com.epam.ta.reportportal.ws.model.EntryCreatedRS;
import com.epam.ta.reportportal.ws.model.OperationCompletionRS;
import com.epam.ta.reportportal.ws.model.project.config.CreateIssueSubTypeRQ;
import com.epam.ta.reportportal.ws.model.project.config.IssueSubTypeCreatedRS;
import com.epam.ta.reportportal.ws.model.project.config.ProjectSettingsResource;
import com.epam.ta.reportportal.ws.model.project.config.UpdateIssueSubTypeRQ;
import com.epam.ta.reportportal.ws.model.project.config.pattern.CreatePatternTemplateRQ;
import com.epam.ta.reportportal.ws.model.project.config.pattern.UpdatePatternTemplateRQ;
import io.swagger.annotations.ApiOperation;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpStatus;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.security.core.annotation.AuthenticationPrincipal;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseStatus;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/v1/{projectName}/settings"})
@PreAuthorize(value="hasPermission(#projectName.toLowerCase(), 'isAssignedToProject')")
public class ProjectSettingsController {
    private final CreateProjectSettingsHandler createHandler;
    private final UpdateProjectSettingsHandler updateHandler;
    private final DeleteProjectSettingsHandler deleteHandler;
    private final GetProjectSettingsHandler getHandler;

    @Autowired
    public ProjectSettingsController(CreateProjectSettingsHandler createHandler, UpdateProjectSettingsHandler updateHandler, DeleteProjectSettingsHandler deleteHandler, GetProjectSettingsHandler getHandler) {
        this.createHandler = createHandler;
        this.updateHandler = updateHandler;
        this.deleteHandler = deleteHandler;
        this.getHandler = getHandler;
    }

    @PostMapping(value={"/sub-type"})
    @ResponseStatus(value=HttpStatus.CREATED)
    @PreAuthorize(value="hasPermission(#projectName.toLowerCase(), 'projectManagerPermission')")
    @ApiOperation(value="Creation of custom project specific issue sub-type")
    public IssueSubTypeCreatedRS createProjectIssueSubType(@PathVariable String projectName, @RequestBody @Validated CreateIssueSubTypeRQ request, @AuthenticationPrincipal ReportPortalUser user) {
        return this.createHandler.createProjectIssueSubType(EntityUtils.normalizeId((String)projectName), user, request);
    }

    @PutMapping(value={"/sub-type"})
    @ResponseStatus(value=HttpStatus.OK)
    @PreAuthorize(value="hasPermission(#projectName.toLowerCase(), 'projectManagerPermission')")
    @ApiOperation(value="Update of custom project specific issue sub-type")
    public OperationCompletionRS updateProjectIssueSubType(@PathVariable String projectName, @RequestBody @Validated UpdateIssueSubTypeRQ request, @AuthenticationPrincipal ReportPortalUser user) {
        return this.updateHandler.updateProjectIssueSubType(EntityUtils.normalizeId((String)projectName), user, request);
    }

    @DeleteMapping(value={"/sub-type/{id}"})
    @ResponseStatus(value=HttpStatus.OK)
    @PreAuthorize(value="hasPermission(#projectName.toLowerCase(), 'projectManagerPermission')")
    @ApiOperation(value="Delete custom project specific issue sub-type")
    public OperationCompletionRS deleteProjectIssueSubType(@PathVariable String projectName, @PathVariable Long id, @AuthenticationPrincipal ReportPortalUser user) {
        return this.deleteHandler.deleteProjectIssueSubType(EntityUtils.normalizeId((String)projectName), user, id);
    }

    @GetMapping
    @ResponseStatus(value=HttpStatus.OK)
    @PreAuthorize(value="hasPermission(#projectName.toLowerCase(), 'isAssignedToProject')")
    @ApiOperation(value="Get project specific issue sub-types", notes="Only for users that are assigned to the project")
    public ProjectSettingsResource getProjectSettings(@PathVariable String projectName, @AuthenticationPrincipal ReportPortalUser user) {
        return this.getHandler.getProjectSettings(EntityUtils.normalizeId((String)projectName));
    }

    @PostMapping(value={"/pattern"})
    @ResponseStatus(value=HttpStatus.CREATED)
    @PreAuthorize(value="hasPermission(#projectName.toLowerCase(), 'projectManagerPermission')")
    @ApiOperation(value="Create pattern template for items' log messages pattern analysis")
    public EntryCreatedRS createPatternTemplate(@PathVariable String projectName, @RequestBody @Validated CreatePatternTemplateRQ createPatternTemplateRQ, @AuthenticationPrincipal ReportPortalUser user) {
        return this.createHandler.createPatternTemplate(EntityUtils.normalizeId((String)projectName), createPatternTemplateRQ, user);
    }

    @PutMapping(value={"/pattern/{id}"})
    @ResponseStatus(value=HttpStatus.OK)
    @PreAuthorize(value="hasPermission(#projectName.toLowerCase(), 'projectManagerPermission')")
    @ApiOperation(value="Update pattern template for items' log messages pattern analysis")
    public OperationCompletionRS updatePatternTemplate(@PathVariable String projectName, @PathVariable Long id, @RequestBody @Validated UpdatePatternTemplateRQ updatePatternTemplateRQ, @AuthenticationPrincipal ReportPortalUser user) {
        return this.updateHandler.updatePatternTemplate(id, EntityUtils.normalizeId((String)projectName), updatePatternTemplateRQ, user);
    }

    @DeleteMapping(value={"/pattern/{id}"})
    @ResponseStatus(value=HttpStatus.OK)
    @PreAuthorize(value="hasPermission(#projectName.toLowerCase(), 'projectManagerPermission')")
    @ApiOperation(value="Delete pattern template for items' log messages pattern analysis")
    public OperationCompletionRS deletePatternTemplate(@PathVariable String projectName, @PathVariable Long id, @AuthenticationPrincipal ReportPortalUser user) {
        return this.deleteHandler.deletePatternTemplate(EntityUtils.normalizeId((String)projectName), user, id);
    }
}

