/*
 * Decompiled with CFR 0.152.
 */
package com.epam.ta.reportportal.ws.controller;

import com.epam.ta.reportportal.commons.EntityUtils;
import com.epam.ta.reportportal.commons.ReportPortalUser;
import com.epam.ta.reportportal.commons.querygen.CompositeFilter;
import com.epam.ta.reportportal.commons.querygen.Filter;
import com.epam.ta.reportportal.commons.querygen.Queryable;
import com.epam.ta.reportportal.core.jasper.GetJasperReportHandler;
import com.epam.ta.reportportal.core.preference.GetPreferenceHandler;
import com.epam.ta.reportportal.core.preference.UpdatePreferenceHandler;
import com.epam.ta.reportportal.core.project.CreateProjectHandler;
import com.epam.ta.reportportal.core.project.DeleteProjectHandler;
import com.epam.ta.reportportal.core.project.GetProjectHandler;
import com.epam.ta.reportportal.core.project.GetProjectInfoHandler;
import com.epam.ta.reportportal.core.project.UpdateProjectHandler;
import com.epam.ta.reportportal.core.user.GetUserHandler;
import com.epam.ta.reportportal.entity.jasper.ReportFormat;
import com.epam.ta.reportportal.entity.project.ProjectInfo;
import com.epam.ta.reportportal.entity.user.User;
import com.epam.ta.reportportal.exception.ReportPortalException;
import com.epam.ta.reportportal.util.ProjectExtractor;
import com.epam.ta.reportportal.ws.model.DeleteBulkRQ;
import com.epam.ta.reportportal.ws.model.DeleteBulkRS;
import com.epam.ta.reportportal.ws.model.EntryCreatedRS;
import com.epam.ta.reportportal.ws.model.ErrorType;
import com.epam.ta.reportportal.ws.model.OperationCompletionRS;
import com.epam.ta.reportportal.ws.model.preference.PreferenceResource;
import com.epam.ta.reportportal.ws.model.project.AssignUsersRQ;
import com.epam.ta.reportportal.ws.model.project.CreateProjectRQ;
import com.epam.ta.reportportal.ws.model.project.ProjectInfoResource;
import com.epam.ta.reportportal.ws.model.project.ProjectResource;
import com.epam.ta.reportportal.ws.model.project.UnassignUsersRQ;
import com.epam.ta.reportportal.ws.model.project.UpdateProjectRQ;
import com.epam.ta.reportportal.ws.model.project.email.ProjectNotificationConfigDTO;
import com.epam.ta.reportportal.ws.model.user.UserResource;
import com.epam.ta.reportportal.ws.resolver.FilterFor;
import com.epam.ta.reportportal.ws.resolver.SortFor;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import java.io.IOException;
import java.io.OutputStream;
import java.security.Principal;
import java.util.List;
import java.util.Map;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletResponse;
import javax.validation.Valid;
import org.jooq.Operator;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.data.domain.Pageable;
import org.springframework.http.HttpStatus;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.security.core.annotation.AuthenticationPrincipal;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.ResponseStatus;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/v1/project"})
public class ProjectController {
    private final GetProjectHandler getProjectHandler;
    private final GetProjectInfoHandler projectInfoHandler;
    private final CreateProjectHandler createProjectHandler;
    private final UpdateProjectHandler updateProjectHandler;
    private final DeleteProjectHandler deleteProjectHandler;
    private final GetUserHandler getUserHandler;
    private final GetPreferenceHandler getPreference;
    private final UpdatePreferenceHandler updatePreference;
    private final GetJasperReportHandler<ProjectInfo> jasperReportHandler;

    @Autowired
    public ProjectController(GetProjectHandler getProjectHandler, GetProjectInfoHandler projectInfoHandler, CreateProjectHandler createProjectHandler, UpdateProjectHandler updateProjectHandler, DeleteProjectHandler deleteProjectHandler, GetUserHandler getUserHandler, GetPreferenceHandler getPreference, UpdatePreferenceHandler updatePreference, @Qualifier(value="projectJasperReportHandler") GetJasperReportHandler<ProjectInfo> jasperReportHandler) {
        this.getProjectHandler = getProjectHandler;
        this.projectInfoHandler = projectInfoHandler;
        this.createProjectHandler = createProjectHandler;
        this.updateProjectHandler = updateProjectHandler;
        this.deleteProjectHandler = deleteProjectHandler;
        this.getUserHandler = getUserHandler;
        this.getPreference = getPreference;
        this.updatePreference = updatePreference;
        this.jasperReportHandler = jasperReportHandler;
    }

    @Transactional
    @PostMapping
    @ResponseStatus(value=HttpStatus.CREATED)
    @PreAuthorize(value="hasRole('ADMINISTRATOR')")
    @ApiOperation(value="Create new project")
    public EntryCreatedRS createProject(@RequestBody @Validated CreateProjectRQ createProjectRQ, @AuthenticationPrincipal ReportPortalUser user) {
        return this.createProjectHandler.createProject(createProjectRQ, user);
    }

    @Transactional
    @PutMapping(value={"/{projectName}"})
    @ResponseStatus(value=HttpStatus.OK)
    @PreAuthorize(value="hasPermission(#projectName.toLowerCase(), 'projectManagerPermission')||hasRole('ADMINISTRATOR')")
    @ApiOperation(value="Update project")
    public OperationCompletionRS updateProject(@PathVariable String projectName, @RequestBody @Validated UpdateProjectRQ updateProjectRQ, @AuthenticationPrincipal ReportPortalUser user) {
        return this.updateProjectHandler.updateProject(EntityUtils.normalizeId((String)projectName), updateProjectRQ, user);
    }

    @Transactional
    @PutMapping(value={"/{projectName}/notification"})
    @ResponseStatus(value=HttpStatus.OK)
    @PreAuthorize(value="hasPermission(#projectName.toLowerCase(), 'projectManagerPermission')")
    @ApiOperation(value="Update project notifications configuration")
    public OperationCompletionRS updateProjectNotificationConfig(@PathVariable String projectName, @RequestBody @Validated ProjectNotificationConfigDTO updateProjectNotificationConfigRQ, @AuthenticationPrincipal ReportPortalUser user) {
        return this.updateProjectHandler.updateProjectNotificationConfig(EntityUtils.normalizeId((String)projectName), user, updateProjectNotificationConfigRQ);
    }

    @Transactional
    @DeleteMapping
    @ResponseStatus(value=HttpStatus.OK)
    @PreAuthorize(value="hasRole('ADMINISTRATOR')")
    @ApiOperation(value="Delete multiple projects", notes="Could be deleted only by users with administrator role")
    public DeleteBulkRS deleteProject(@RequestBody @Valid DeleteBulkRQ deleteBulkRQ, @AuthenticationPrincipal ReportPortalUser user) {
        return this.deleteProjectHandler.deleteProjects(deleteBulkRQ);
    }

    @Transactional
    @DeleteMapping(value={"/{projectId}"})
    @ResponseStatus(value=HttpStatus.OK)
    @PreAuthorize(value="hasRole('ADMINISTRATOR')")
    @ApiOperation(value="Delete project", notes="Could be deleted only by users with administrator role")
    public OperationCompletionRS deleteProject(@PathVariable Long projectId, @AuthenticationPrincipal ReportPortalUser user) {
        return this.deleteProjectHandler.deleteProject(projectId);
    }

    @Transactional
    @DeleteMapping(value={"/{projectName}/index"})
    @ResponseStatus(value=HttpStatus.OK)
    @PreAuthorize(value="hasPermission(#projectName.toLowerCase(), 'projectManagerPermission')||hasRole('ADMINISTRATOR')")
    @ApiOperation(value="Delete project index from ML")
    public OperationCompletionRS deleteProjectIndex(@PathVariable String projectName, Principal principal) {
        return this.deleteProjectHandler.deleteProjectIndex(EntityUtils.normalizeId((String)projectName), principal.getName());
    }

    @Transactional
    @PutMapping(value={"/{projectName}/index"})
    @ResponseStatus(value=HttpStatus.OK)
    @PreAuthorize(value="hasPermission(#projectName.toLowerCase(), 'projectManagerPermission')||hasRole('ADMINISTRATOR')")
    @ApiOperation(value="Starts reindex all project data in ML")
    public OperationCompletionRS indexProjectData(@PathVariable String projectName, @AuthenticationPrincipal ReportPortalUser user) {
        return this.updateProjectHandler.indexProjectData(EntityUtils.normalizeId((String)projectName), user);
    }

    @Transactional(readOnly=true)
    @GetMapping(value={"/{projectName}/users"})
    @PreAuthorize(value="hasPermission(#projectName.toLowerCase(), 'notCustomerPermission')")
    @ApiOperation(value="Get users assigned on current project")
    public Iterable<UserResource> getProjectUsers(@PathVariable String projectName, @FilterFor(value=User.class) Filter filter, @SortFor(value=User.class) Pageable pageable, @AuthenticationPrincipal ReportPortalUser user) {
        return this.getProjectHandler.getProjectUsers(EntityUtils.normalizeId((String)projectName), filter, pageable);
    }

    @Transactional(readOnly=true)
    @GetMapping(value={"/{projectName}"})
    @PreAuthorize(value="hasPermission(#projectName.toLowerCase(), 'isAssignedToProject')")
    @ApiOperation(value="Get information about project", notes="Only for users that are assigned to the project")
    public ProjectResource getProject(@PathVariable String projectName, @AuthenticationPrincipal ReportPortalUser user) {
        return this.getProjectHandler.getProject(EntityUtils.normalizeId((String)projectName), user);
    }

    @Transactional
    @PutMapping(value={"/{projectName}/unassign"})
    @ResponseStatus(value=HttpStatus.OK)
    @PreAuthorize(value="hasPermission(#projectName.toLowerCase(), 'projectManagerPermission')")
    @ApiOperation(value="Un assign users")
    public OperationCompletionRS unassignProjectUsers(@PathVariable String projectName, @RequestBody @Validated UnassignUsersRQ unassignUsersRQ, @AuthenticationPrincipal ReportPortalUser user) {
        return this.updateProjectHandler.unassignUsers(EntityUtils.normalizeId((String)projectName), unassignUsersRQ, user);
    }

    @Transactional
    @PutMapping(value={"/{projectName}/assign"})
    @ResponseStatus(value=HttpStatus.OK)
    @PreAuthorize(value="hasPermission(#projectName.toLowerCase(), 'projectManagerPermission')")
    @ApiOperation(value="Assign users")
    public OperationCompletionRS assignProjectUsers(@PathVariable String projectName, @RequestBody @Validated AssignUsersRQ assignUsersRQ, @AuthenticationPrincipal ReportPortalUser user) {
        return this.updateProjectHandler.assignUsers(projectName, assignUsersRQ, user);
    }

    @Transactional(readOnly=true)
    @GetMapping(value={"/{projectName}/assignable"})
    @ResponseStatus(value=HttpStatus.OK)
    @PreAuthorize(value="hasPermission(#projectName.toLowerCase(), 'projectManagerPermission')")
    @ApiOperation(value="Load users which can be assigned to specified project", notes="Only for users with project manager permissions")
    public Iterable<UserResource> getUsersForAssign(@FilterFor(value=User.class) Filter filter, @SortFor(value=User.class) Pageable pageable, @PathVariable String projectName, @AuthenticationPrincipal ReportPortalUser user) {
        return this.getUserHandler.getUsers(filter, pageable, ProjectExtractor.extractProjectDetails(user, projectName));
    }

    @Transactional(readOnly=true)
    @GetMapping(value={"/{projectName}/usernames"})
    @ResponseStatus(value=HttpStatus.OK)
    @PreAuthorize(value="hasPermission(#projectName.toLowerCase(), 'notCustomerPermission')")
    @ApiOperation(value="Load project users by filter", notes="Only for users that are members of the project")
    public List<String> getProjectUsers(@PathVariable String projectName, @RequestParam(value="filter.cnt.users") String value, @AuthenticationPrincipal ReportPortalUser user) {
        return this.getProjectHandler.getUserNames(ProjectExtractor.extractProjectDetails(user, projectName), EntityUtils.normalizeId((String)value));
    }

    @Transactional(readOnly=true)
    @GetMapping(value={"/{projectName}/usernames/search"})
    @ResponseStatus(value=HttpStatus.OK)
    @PreAuthorize(value="hasPermission(#projectName.toLowerCase(), 'projectManagerPermission')")
    public Iterable<UserResource> searchForUser(@PathVariable String projectName, @RequestParam(value="term") String term, Pageable pageable, @AuthenticationPrincipal ReportPortalUser user) {
        ProjectExtractor.extractProjectDetails(user, projectName);
        return this.getProjectHandler.getUserNames(term, pageable);
    }

    @Transactional
    @PutMapping(value={"/{projectName}/preference/{login}/{filterId}"})
    @ResponseStatus(value=HttpStatus.OK)
    @PreAuthorize(value="(#login.toLowerCase() == authentication.name) || hasRole('ADMINISTRATOR')")
    public OperationCompletionRS addUserPreference(@PathVariable String projectName, @PathVariable String login, @PathVariable Long filterId, @AuthenticationPrincipal ReportPortalUser user) {
        return this.updatePreference.addPreference(ProjectExtractor.extractProjectDetails(user, projectName), user, filterId);
    }

    @Transactional
    @DeleteMapping(value={"/{projectName}/preference/{login}/{filterId}"})
    @ResponseStatus(value=HttpStatus.OK)
    @PreAuthorize(value="(#login.toLowerCase() == authentication.name) || hasRole('ADMINISTRATOR')")
    public OperationCompletionRS removeUserPreference(@PathVariable String projectName, @PathVariable String login, @PathVariable Long filterId, @AuthenticationPrincipal ReportPortalUser user) {
        return this.updatePreference.removePreference(ProjectExtractor.extractProjectDetails(user, projectName), user, filterId);
    }

    @Transactional(readOnly=true)
    @GetMapping(value={"/{projectName}/preference/{login}"})
    @ResponseStatus(value=HttpStatus.OK)
    @PreAuthorize(value="(#login.toLowerCase() == authentication.name) || hasRole('ADMINISTRATOR')")
    @ApiOperation(value="Load user preferences", notes="Only for users that allowed to edit other users")
    public PreferenceResource getUserPreference(@PathVariable String projectName, @PathVariable String login, @AuthenticationPrincipal ReportPortalUser user) {
        return this.getPreference.getPreference(ProjectExtractor.extractProjectDetails(user, projectName), user);
    }

    @Transactional(readOnly=true)
    @PreAuthorize(value="hasRole('ADMINISTRATOR')")
    @GetMapping(value={"/list"})
    @ResponseStatus(value=HttpStatus.OK)
    public Iterable<ProjectInfoResource> getAllProjectsInfo(@FilterFor(value=ProjectInfo.class) Filter filter, @FilterFor(value=ProjectInfo.class) Queryable predefinedFilter, @SortFor(value=ProjectInfo.class) Pageable pageable, @AuthenticationPrincipal ReportPortalUser user) {
        return this.projectInfoHandler.getAllProjectsInfo((Queryable)new CompositeFilter(Operator.AND, new Queryable[]{filter, predefinedFilter}), pageable);
    }

    @Transactional(readOnly=true)
    @PreAuthorize(value="hasRole('ADMINISTRATOR')")
    @GetMapping(value={"/export"})
    @ResponseStatus(value=HttpStatus.OK)
    @ApiOperation(value="Exports information about all projects", notes="Allowable only for users with administrator role")
    public void exportProjects(@ApiParam(allowableValues="csv") @RequestParam(value="view", required=false, defaultValue="csv") String view, @FilterFor(value=ProjectInfo.class) Filter filter, @FilterFor(value=ProjectInfo.class) Queryable predefinedFilter, @AuthenticationPrincipal ReportPortalUser user, HttpServletResponse response) {
        ReportFormat format = this.jasperReportHandler.getReportFormat(view);
        response.setContentType(format.getContentType());
        response.setHeader("Content-Disposition", String.format("attachment; filename=RP_PROJECTS_%s_Report.%s", format.name(), format.getValue()));
        try (ServletOutputStream outputStream = response.getOutputStream();){
            this.getProjectHandler.exportProjects(format, (Queryable)new CompositeFilter(Operator.AND, new Queryable[]{filter, predefinedFilter}), (OutputStream)outputStream);
        }
        catch (IOException e) {
            throw new ReportPortalException(ErrorType.BAD_REQUEST_ERROR, new Object[]{"Unable to write data to the response."});
        }
    }

    @Transactional(readOnly=true)
    @PreAuthorize(value="hasPermission(#projectName.toLowerCase(), 'isAssignedToProject')")
    @GetMapping(value={"/list/{projectName}"})
    @ResponseStatus(value=HttpStatus.OK)
    public ProjectInfoResource getProjectInfo(@PathVariable String projectName, @RequestParam(value="interval", required=false, defaultValue="3M") String interval, @AuthenticationPrincipal ReportPortalUser user) {
        return this.projectInfoHandler.getProjectInfo(projectName, interval);
    }

    @Transactional(readOnly=true)
    @PreAuthorize(value="hasPermission(#projectName.toLowerCase(), 'isAssignedToProject')")
    @GetMapping(value={"/{projectName}/widget/{widgetCode}"})
    @ResponseStatus(value=HttpStatus.OK)
    public Map<String, ?> getProjectWidget(@PathVariable String projectName, @RequestParam(value="interval", required=false, defaultValue="3M") String interval, @PathVariable String widgetCode, @AuthenticationPrincipal ReportPortalUser user) {
        return this.projectInfoHandler.getProjectInfoWidgetContent(projectName, interval, widgetCode);
    }

    @Transactional(readOnly=true)
    @PreAuthorize(value="hasRole('ADMINISTRATOR')")
    @GetMapping(value={"/names"})
    @ResponseStatus(value=HttpStatus.OK)
    public Iterable<String> getAllProjectNames(@AuthenticationPrincipal ReportPortalUser user) {
        return this.getProjectHandler.getAllProjectNames();
    }

    @Transactional(readOnly=true)
    @PreAuthorize(value="hasRole('ADMINISTRATOR')")
    @GetMapping(value={"/names/search"})
    @ResponseStatus(value=HttpStatus.OK)
    public Iterable<String> searchProjectNames(@RequestParam(value="term") String term, @AuthenticationPrincipal ReportPortalUser user) {
        return this.getProjectHandler.getAllProjectNamesByTerm(term);
    }

    @Transactional(readOnly=true)
    @PreAuthorize(value="hasRole('ADMINISTRATOR')")
    @GetMapping(value={"analyzer/status"})
    @ResponseBody
    @ResponseStatus(value=HttpStatus.OK)
    public Map<String, Boolean> getAnalyzerIndexingStatus(@AuthenticationPrincipal ReportPortalUser user) {
        return this.getProjectHandler.getAnalyzerIndexingStatus();
    }
}

