/*
 * Decompiled with CFR 0.152.
 */
package com.epam.ta.reportportal.util.email;

import com.epam.ta.reportportal.commons.Predicates;
import com.epam.ta.reportportal.commons.validation.BusinessRule;
import com.epam.ta.reportportal.commons.validation.Suppliers;
import com.epam.ta.reportportal.entity.project.Project;
import com.epam.ta.reportportal.entity.project.ProjectUtils;
import com.epam.ta.reportportal.util.UserUtils;
import com.epam.ta.reportportal.ws.model.ErrorType;
import com.epam.ta.reportportal.ws.model.attribute.ItemAttributeResource;
import com.google.common.base.Strings;
import java.util.function.Predicate;
import org.apache.commons.lang3.StringUtils;

public final class EmailRulesValidator {
    private EmailRulesValidator() {
    }

    public static void validateRecipient(Project project, String recipient) {
        BusinessRule.expect((Object)recipient, (Predicate)Predicates.notNull()).verify(ErrorType.BAD_REQUEST_ERROR, new Object[]{Suppliers.formattedSupplier((String)"Provided recipient email '{}' is invalid", (Object[])new Object[]{recipient})});
        if (recipient.contains("@")) {
            BusinessRule.expect((Object)UserUtils.isEmailValid((String)recipient), (Predicate)Predicates.equalTo((Object)true)).verify(ErrorType.BAD_REQUEST_ERROR, new Object[]{Suppliers.formattedSupplier((String)"Provided recipient email '{}' is invalid", (Object[])new Object[]{recipient})});
        } else {
            String login = recipient.trim();
            BusinessRule.expect((Object)(1 <= login.length() && login.length() <= 128 ? 1 : 0), (Predicate)Predicates.equalTo((Object)true)).verify(ErrorType.BAD_REQUEST_ERROR, new Object[]{"Acceptable login length  [1..128]"});
            if (!ProjectUtils.getOwner().equals(login)) {
                BusinessRule.expect((Object)ProjectUtils.doesHaveUser((Project)project, (String)login.toLowerCase()), (Predicate)Predicates.equalTo((Object)true)).verify(ErrorType.USER_NOT_FOUND, new Object[]{login, String.format("User not found in project %s", project.getId())});
            }
        }
    }

    public static void validateLaunchName(String name) {
        BusinessRule.expect((Object)StringUtils.isBlank((CharSequence)name), (Predicate)Predicates.equalTo((Object)false)).verify(ErrorType.BAD_REQUEST_ERROR, new Object[]{"Launch name values cannot be empty. Please specify it or not include in request."});
        BusinessRule.expect((Object)(name.length() <= 256 ? 1 : 0), (Predicate)Predicates.equalTo((Object)true)).verify(ErrorType.BAD_REQUEST_ERROR, new Object[]{Suppliers.formattedSupplier((String)"One of provided launch names '{}' is too long. Acceptable name length is [1..256]", (Object[])new Object[]{name})});
    }

    public static void validateLaunchAttribute(ItemAttributeResource attribute) {
        BusinessRule.expect((Object)attribute, (Predicate)Predicates.notNull()).verify(ErrorType.BAD_REQUEST_ERROR, new Object[]{"Launch attribute cannot be null."});
        BusinessRule.expect((Object)Strings.isNullOrEmpty((String)attribute.getValue()), (Predicate)Predicates.equalTo((Object)false)).verify(ErrorType.BAD_REQUEST_ERROR, new Object[]{"Attribute' values cannot be empty. Please specify them or do not include in a request."});
    }
}

