/*
 * Decompiled with CFR 0.152.
 */
package com.epam.ta.reportportal.util;

import com.epam.ta.reportportal.commons.EntityUtils;
import com.epam.ta.reportportal.commons.ReportPortalUser;
import com.epam.ta.reportportal.dao.ProjectRepository;
import com.epam.ta.reportportal.entity.project.Project;
import com.epam.ta.reportportal.entity.project.ProjectRole;
import com.epam.ta.reportportal.entity.user.UserRole;
import com.epam.ta.reportportal.exception.ReportPortalException;
import com.epam.ta.reportportal.ws.model.ErrorType;
import java.util.Optional;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class ProjectExtractor {
    @Autowired
    private ProjectRepository projectRepository;

    public static ReportPortalUser.ProjectDetails extractProjectDetails(ReportPortalUser user, String projectName) {
        return (ReportPortalUser.ProjectDetails)Optional.ofNullable(user.getProjectDetails().get(EntityUtils.normalizeId((String)projectName))).orElseThrow(() -> new ReportPortalException(ErrorType.ACCESS_DENIED, new Object[]{"Please check the list of your available projects."}));
    }

    public ReportPortalUser.ProjectDetails extractProjectDetailsAdmin(ReportPortalUser user, String projectName) {
        if (user.getUserRole().getAuthority().equals(UserRole.ADMINISTRATOR.getAuthority())) {
            Project project = (Project)this.projectRepository.findByName(EntityUtils.normalizeId((String)projectName)).orElseThrow(() -> new ReportPortalException(ErrorType.PROJECT_NOT_FOUND, new Object[]{projectName}));
            user.getProjectDetails().put(projectName, new ReportPortalUser.ProjectDetails(project.getId(), project.getName(), ProjectRole.PROJECT_MANAGER));
        }
        return (ReportPortalUser.ProjectDetails)Optional.ofNullable(user.getProjectDetails().get(EntityUtils.normalizeId((String)projectName))).orElseThrow(() -> new ReportPortalException(ErrorType.ACCESS_DENIED, new Object[]{"Please check the list of your available projects."}));
    }
}

