/*
 * Decompiled with CFR 0.152.
 */
package com.epam.ta.reportportal.job;

import com.epam.ta.reportportal.binary.DataStoreService;
import com.epam.ta.reportportal.commons.EntityUtils;
import com.epam.ta.reportportal.dao.ActivityRepository;
import com.epam.ta.reportportal.dao.AttachmentRepository;
import com.epam.ta.reportportal.dao.LaunchRepository;
import com.epam.ta.reportportal.dao.LogRepository;
import com.epam.ta.reportportal.dao.TestItemRepository;
import com.epam.ta.reportportal.entity.log.Log;
import com.epam.ta.reportportal.entity.project.Project;
import com.epam.ta.reportportal.job.CleanLogsJob;
import com.epam.ta.reportportal.job.LogCleanerService;
import java.time.Duration;
import java.time.Instant;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.atomic.AtomicLong;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class LogCleanerServiceImpl
implements LogCleanerService {
    private static final Logger LOGGER = LoggerFactory.getLogger(LogCleanerServiceImpl.class);
    private final LogRepository logRepository;
    private final LaunchRepository launchRepository;
    private final TestItemRepository testItemRepository;
    private final ActivityRepository activityRepository;
    private final AttachmentRepository attachmentRepository;
    private final DataStoreService dataStoreService;

    @Autowired
    public LogCleanerServiceImpl(LogRepository logRepository, LaunchRepository launchRepository, TestItemRepository testItemRepository, ActivityRepository activityRepository, @Qualifier(value="attachmentDataStoreService") DataStoreService dataStoreService, AttachmentRepository attachmentRepository) {
        this.logRepository = logRepository;
        this.launchRepository = launchRepository;
        this.testItemRepository = testItemRepository;
        this.activityRepository = activityRepository;
        this.dataStoreService = dataStoreService;
        this.attachmentRepository = attachmentRepository;
    }

    @Override
    @Transactional
    public void removeOutdatedLogs(Project project, Duration period, AtomicLong removedLogsCount) {
        Date endDate = Date.from(Instant.now().minusSeconds(CleanLogsJob.MIN_DELAY.getSeconds()));
        AtomicLong removedLogsInThreadCount = new AtomicLong(0L);
        AtomicLong attachmentsCount = new AtomicLong(0L);
        AtomicLong thumbnailsCount = new AtomicLong(0L);
        this.activityRepository.deleteModifiedLaterAgo(project.getId(), period);
        try (Stream launchIds = this.launchRepository.streamIdsModifiedBefore(project.getId(), (LocalDateTime)EntityUtils.TO_LOCAL_DATE_TIME.apply(endDate));){
            launchIds.forEach(id -> {
                try (Stream ids = this.testItemRepository.streamTestItemIdsByLaunchId(id);){
                    List itemIds = ids.peek(itemId -> {
                        List logs = this.logRepository.findLogsWithThumbnailByTestItemIdAndPeriod(itemId, period);
                        this.removeAttachmentsOfLogs(logs, attachmentsCount, thumbnailsCount);
                    }).collect(Collectors.toList());
                    long count = this.logRepository.deleteByPeriodAndTestItemIds(period, itemIds);
                    removedLogsCount.addAndGet(count);
                    removedLogsInThreadCount.addAndGet(count);
                }
                catch (Exception e) {
                    LOGGER.error("Error during cleaning outdated logs {}", (Throwable)e);
                }
            });
        }
        catch (Exception e) {
            LOGGER.error("Error during cleaning outdated logs {}", (Throwable)e);
        }
        if (removedLogsInThreadCount.get() > 0L || attachmentsCount.get() > 0L || attachmentsCount.get() > 0L || thumbnailsCount.get() > 0L) {
            LOGGER.info("Removed {} logs for project {} with {} attachments and {} thumbnails", new Object[]{removedLogsInThreadCount.get(), project.getId(), attachmentsCount.get(), thumbnailsCount.get()});
        }
    }

    @Override
    @Transactional
    public void removeProjectAttachments(Project project, Duration period, AtomicLong removedAttachmentsCount, AtomicLong removedThumbnailsCount) {
        Date endDate = Date.from(Instant.now().minusSeconds(CleanLogsJob.MIN_DELAY.getSeconds()));
        try (Stream launchIds = this.launchRepository.streamIdsModifiedBefore(project.getId(), (LocalDateTime)EntityUtils.TO_LOCAL_DATE_TIME.apply(endDate));){
            launchIds.forEach(id -> {
                try (Stream ids = this.testItemRepository.streamTestItemIdsByLaunchId(id);){
                    ids.forEach(itemId -> {
                        List logs = this.logRepository.findLogsWithThumbnailByTestItemIdAndPeriod(itemId, period);
                        this.removeAttachmentsOfLogs(logs, removedAttachmentsCount, removedThumbnailsCount);
                    });
                }
                catch (Exception e) {
                    LOGGER.error("Error during cleaning project attachments {}", (Throwable)e);
                }
            });
        }
        catch (Exception e) {
            LOGGER.error("Error during cleaning project attachments {}", (Throwable)e);
        }
    }

    private void removeAttachmentsOfLogs(Collection<Log> logs, AtomicLong attachmentsCount, AtomicLong thumbnailsCount) {
        ArrayList attachmentIds = new ArrayList();
        logs.forEach(log -> {
            try {
                Optional.ofNullable(log.getAttachment()).ifPresent(attachment -> {
                    Optional.ofNullable(attachment.getFileId()).ifPresent(fileId -> {
                        this.dataStoreService.delete(fileId);
                        attachmentsCount.addAndGet(1L);
                    });
                    Optional.ofNullable(attachment.getThumbnailId()).ifPresent(thumbnailId -> {
                        this.dataStoreService.delete(thumbnailId);
                        thumbnailsCount.addAndGet(1L);
                    });
                    attachmentIds.add(attachment.getId());
                });
            }
            catch (Exception ex) {
                LOGGER.debug("Error has occurred during the attachments removing", (Throwable)ex);
            }
        });
        this.attachmentRepository.deleteAllByIds(attachmentIds);
    }
}

