/*
 * Decompiled with CFR 0.152.
 */
package com.epam.ta.reportportal.job;

import com.epam.ta.reportportal.commons.EntityUtils;
import com.epam.ta.reportportal.dao.ActivityRepository;
import com.epam.ta.reportportal.dao.LaunchRepository;
import com.epam.ta.reportportal.entity.project.Project;
import com.epam.ta.reportportal.job.LaunchCleanerService;
import java.sql.Date;
import java.time.Duration;
import java.time.Instant;
import java.time.LocalDateTime;
import java.util.concurrent.atomic.AtomicLong;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class LaunchCleanerServiceImpl
implements LaunchCleanerService {
    private final LaunchRepository launchRepository;
    private final ActivityRepository activityRepository;

    @Autowired
    public LaunchCleanerServiceImpl(LaunchRepository launchRepository, ActivityRepository activityRepository) {
        this.launchRepository = launchRepository;
        this.activityRepository = activityRepository;
    }

    @Override
    @Transactional
    public void cleanOutdatedLaunches(Project project, Duration period, AtomicLong launchesRemoved) {
        this.activityRepository.deleteModifiedLaterAgo(project.getId(), period);
        launchesRemoved.addAndGet(this.launchRepository.deleteLaunchesByProjectIdModifiedBefore(project.getId(), (LocalDateTime)EntityUtils.TO_LOCAL_DATE_TIME.apply(Date.from(Instant.now().minusSeconds(period.getSeconds())))));
    }
}

