/*
 * Decompiled with CFR 0.152.
 */
package com.epam.ta.reportportal.job;

import com.epam.ta.reportportal.commons.EntityUtils;
import com.epam.ta.reportportal.commons.querygen.Condition;
import com.epam.ta.reportportal.commons.querygen.ConvertibleCondition;
import com.epam.ta.reportportal.commons.querygen.Filter;
import com.epam.ta.reportportal.commons.querygen.FilterCondition;
import com.epam.ta.reportportal.commons.querygen.Queryable;
import com.epam.ta.reportportal.dao.LaunchRepository;
import com.epam.ta.reportportal.dao.LogRepository;
import com.epam.ta.reportportal.dao.ProjectRepository;
import com.epam.ta.reportportal.dao.TestItemRepository;
import com.epam.ta.reportportal.entity.enums.InterruptionJobDelay;
import com.epam.ta.reportportal.entity.enums.ProjectAttributeEnum;
import com.epam.ta.reportportal.entity.enums.StatusEnum;
import com.epam.ta.reportportal.entity.project.Project;
import com.epam.ta.reportportal.exception.ReportPortalException;
import com.epam.ta.reportportal.job.PageUtil;
import java.sql.Date;
import java.time.Duration;
import java.time.Instant;
import java.time.LocalDateTime;
import java.time.ZoneOffset;
import java.util.stream.Stream;
import org.quartz.Job;
import org.quartz.JobExecutionContext;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class InterruptBrokenLaunchesJob
implements Job {
    private final LaunchRepository launchRepository;
    private final TestItemRepository testItemRepository;
    private final LogRepository logRepository;
    private final ProjectRepository projectRepository;

    @Autowired
    public InterruptBrokenLaunchesJob(LaunchRepository launchRepository, TestItemRepository testItemRepository, LogRepository logRepository, ProjectRepository projectRepository) {
        this.launchRepository = launchRepository;
        this.testItemRepository = testItemRepository;
        this.logRepository = logRepository;
        this.projectRepository = projectRepository;
    }

    @Transactional
    public void execute(JobExecutionContext context) {
        PageUtil.iterateOverPages(pageable -> this.projectRepository.findAllIdsAndProjectAttributes((Queryable)this.buildProjectAttributesFilter(ProjectAttributeEnum.INTERRUPT_JOB_TIME), pageable), projects -> projects.forEach(project -> project.getProjectAttributes().stream().filter(pa -> pa.getAttribute().getName().equalsIgnoreCase(ProjectAttributeEnum.INTERRUPT_JOB_TIME.getAttribute())).findFirst().ifPresent(pa -> {
            Duration maxDuration = Duration.ofHours(((InterruptionJobDelay)InterruptionJobDelay.findByName((String)pa.getValue()).orElseThrow(() -> new ReportPortalException("Incorrect launch interruption delay period: " + pa.getValue()))).getPeriod());
            try (Stream ids = this.launchRepository.streamIdsWithStatusModifiedBefore(project.getId(), StatusEnum.IN_PROGRESS, (LocalDateTime)EntityUtils.TO_LOCAL_DATE_TIME.apply(Date.from(Instant.now().minusSeconds(maxDuration.getSeconds()))));){
                ids.forEach(launchId -> {
                    if (!this.testItemRepository.hasItemsInStatusByLaunch(launchId, new StatusEnum[]{StatusEnum.IN_PROGRESS}).booleanValue()) {
                        this.interruptLaunch((Long)launchId);
                    } else if (!this.testItemRepository.hasItemsInStatusAddedLately(launchId, maxDuration, new StatusEnum[]{StatusEnum.IN_PROGRESS}).booleanValue()) {
                        if (this.testItemRepository.hasLogs(launchId, maxDuration, new StatusEnum[]{StatusEnum.IN_PROGRESS}).booleanValue()) {
                            if (!this.logRepository.hasLogsAddedLately(maxDuration, launchId, new StatusEnum[]{StatusEnum.IN_PROGRESS})) {
                                this.interruptItems((Long)launchId);
                            }
                        } else {
                            this.interruptItems((Long)launchId);
                        }
                    }
                });
            }
            catch (Exception exception) {
                // empty catch block
            }
        })));
    }

    private Filter buildProjectAttributesFilter(ProjectAttributeEnum projectAttributeEnum) {
        return Filter.builder().withTarget(Project.class).withCondition((ConvertibleCondition)new FilterCondition(Condition.EQUALS, false, projectAttributeEnum.getAttribute(), "attributeName")).build();
    }

    private void interruptLaunch(Long launchId) {
        this.launchRepository.findById((Object)launchId).ifPresent(launch -> {
            launch.setStatus(StatusEnum.INTERRUPTED);
            launch.setEndTime(LocalDateTime.now(ZoneOffset.UTC));
            this.launchRepository.save(launch);
        });
    }

    private void interruptItems(Long launchId) {
        this.testItemRepository.interruptInProgressItems(launchId);
        this.launchRepository.findById((Object)launchId).ifPresent(l -> {
            l.setStatus(StatusEnum.INTERRUPTED);
            l.setEndTime(LocalDateTime.now(ZoneOffset.UTC));
            this.launchRepository.save(l);
        });
    }
}

