/*
 * Decompiled with CFR 0.152.
 */
package com.epam.ta.reportportal.core.widget.util;

import com.epam.ta.reportportal.commons.querygen.Filter;
import com.epam.ta.reportportal.exception.ReportPortalException;
import com.epam.ta.reportportal.ws.model.ErrorType;
import com.google.common.collect.Lists;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.springframework.data.domain.Sort;

public class WidgetFilterUtil {
    public static final Function<Set<Filter>, Filter> GROUP_FILTERS = filters -> {
        Filter filter = (Filter)Optional.ofNullable(filters).map(Collection::stream).orElseThrow(() -> new ReportPortalException(ErrorType.BAD_REQUEST_ERROR, new Object[]{"Filters set should not be empty"})).findFirst().orElseThrow(() -> new ReportPortalException(ErrorType.BAD_REQUEST_ERROR, new Object[]{"No filters for widget were found"}));
        filter.withConditions(filters.stream().map(Filter::getFilterConditions).flatMap(Collection::stream).collect(Collectors.toList()));
        return filter;
    };
    public static final Function<Collection<Sort>, Sort> GROUP_SORTS = sorts -> Sort.by((List)Optional.ofNullable(sorts).map(s -> s.stream().flatMap(sortStream -> Lists.newArrayList((Iterator)sortStream.iterator()).stream()).collect(Collectors.toList())).orElseGet(Lists::newArrayList));

    private WidgetFilterUtil() {
    }
}

