/*
 * Decompiled with CFR 0.152.
 */
package com.epam.ta.reportportal.core.widget.content.loader;

import com.epam.ta.reportportal.commons.Predicates;
import com.epam.ta.reportportal.commons.querygen.Filter;
import com.epam.ta.reportportal.commons.validation.BusinessRule;
import com.epam.ta.reportportal.core.widget.content.LoadContentStrategy;
import com.epam.ta.reportportal.core.widget.util.WidgetFilterUtil;
import com.epam.ta.reportportal.core.widget.util.WidgetOptionUtil;
import com.epam.ta.reportportal.dao.WidgetContentRepository;
import com.epam.ta.reportportal.entity.widget.WidgetOptions;
import com.epam.ta.reportportal.entity.widget.content.OverallStatisticsContent;
import com.epam.ta.reportportal.ws.model.ErrorType;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.function.Predicate;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.collections.MapUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Sort;
import org.springframework.stereotype.Service;

@Service
public class OverallStatisticsContentLoader
implements LoadContentStrategy {
    @Autowired
    private WidgetContentRepository widgetContentRepository;

    @Override
    public Map<String, ?> loadContent(List<String> contentFields, Map<Filter, Sort> filterSortMapping, WidgetOptions widgetOptions, int limit) {
        this.validateContentFields(contentFields);
        Filter filter = WidgetFilterUtil.GROUP_FILTERS.apply(filterSortMapping.keySet());
        Sort sort = WidgetFilterUtil.GROUP_SORTS.apply(filterSortMapping.values());
        boolean latestMode = WidgetOptionUtil.getBooleanByKey("latest", widgetOptions);
        OverallStatisticsContent content = this.widgetContentRepository.overallStatisticsContent(filter, sort, contentFields, latestMode, limit);
        return MapUtils.isEmpty((Map)content.getValues()) ? Collections.emptyMap() : Collections.singletonMap("result", Collections.singletonList(content));
    }

    private void validateContentFields(List<String> contentFields) {
        BusinessRule.expect((Object)CollectionUtils.isNotEmpty(contentFields), (Predicate)Predicates.equalTo((Object)true)).verify(ErrorType.BAD_REQUEST_ERROR, new Object[]{"Content fields should not be empty"});
    }
}

