/*
 * Decompiled with CFR 0.152.
 */
package com.epam.ta.reportportal.core.widget.content.loader;

import com.epam.ta.reportportal.commons.Predicates;
import com.epam.ta.reportportal.commons.querygen.Condition;
import com.epam.ta.reportportal.commons.querygen.ConvertibleCondition;
import com.epam.ta.reportportal.commons.querygen.Filter;
import com.epam.ta.reportportal.commons.querygen.FilterCondition;
import com.epam.ta.reportportal.commons.validation.BusinessRule;
import com.epam.ta.reportportal.core.widget.content.MultilevelLoadContentStrategy;
import com.epam.ta.reportportal.core.widget.util.ContentFieldMatcherUtil;
import com.epam.ta.reportportal.core.widget.util.ContentFieldPatternConstants;
import com.epam.ta.reportportal.core.widget.util.WidgetFilterUtil;
import com.epam.ta.reportportal.core.widget.util.WidgetOptionUtil;
import com.epam.ta.reportportal.dao.WidgetContentRepository;
import com.epam.ta.reportportal.entity.widget.WidgetOptions;
import com.epam.ta.reportportal.ws.model.ErrorType;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.collections.MapUtils;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Sort;
import org.springframework.stereotype.Service;

@Service
public class CumulativeTrendChartLoader
implements MultilevelLoadContentStrategy {
    @Autowired
    private WidgetContentRepository widgetContentRepository;

    @Override
    public Map<String, ?> loadContent(List<String> contentFields, Map<Filter, Sort> filterSortMapping, WidgetOptions widgetOptions, String[] attributes, Map<String, String> params, int limit) {
        List content;
        this.validateFilterSortMapping(filterSortMapping);
        this.validateContentFields(contentFields);
        Filter filter = WidgetFilterUtil.GROUP_FILTERS.apply(filterSortMapping.keySet());
        Sort sort = WidgetFilterUtil.GROUP_SORTS.apply(filterSortMapping.values());
        List storedAttributes = WidgetOptionUtil.getListByKey("attributes", widgetOptions);
        if (ArrayUtils.isEmpty((Object[])attributes)) {
            content = this.widgetContentRepository.cumulativeTrendStatistics(filter, contentFields, sort, storedAttributes.size() > 0 ? (String)storedAttributes.get(0) : null, storedAttributes.size() > 1 ? (String)storedAttributes.get(1) : null, limit);
        } else {
            Map<String, String> requestAttributesMapping = this.getAttributesMapping(attributes);
            BusinessRule.expect((Object)storedAttributes.containsAll(requestAttributesMapping.keySet()), Predicate.isEqual(true)).verify(ErrorType.BAD_REQUEST_ERROR, new Object[]{"attributes"});
            requestAttributesMapping.forEach((key, value) -> filter.withCondition((ConvertibleCondition)FilterCondition.builder().withSearchCriteria("attributeKey").withCondition(Condition.HAS).withValue(key).build()).withCondition((ConvertibleCondition)FilterCondition.builder().withSearchCriteria("attributeValue").withCondition(Condition.HAS).withValue(value).build()));
            content = this.widgetContentRepository.cumulativeTrendStatistics(filter, contentFields, sort, (String)storedAttributes.get(1), null, limit);
        }
        return content.isEmpty() ? Collections.emptyMap() : Collections.singletonMap("result", content);
    }

    private void validateFilterSortMapping(Map<Filter, Sort> filterSortMapping) {
        BusinessRule.expect((Object)MapUtils.isNotEmpty(filterSortMapping), (Predicate)Predicates.equalTo((Object)true)).verify(ErrorType.BAD_REQUEST_ERROR, new Object[]{"Filter-Sort mapping should not be empty"});
    }

    private void validateContentFields(List<String> contentFields) {
        BusinessRule.expect((Object)CollectionUtils.isNotEmpty(contentFields), (Predicate)Predicates.equalTo((Object)true)).verify(ErrorType.BAD_REQUEST_ERROR, new Object[]{"Content fields should not be empty"});
        BusinessRule.expect((Object)ContentFieldMatcherUtil.match(ContentFieldPatternConstants.COMBINED_CONTENT_FIELDS_REGEX, contentFields), (Predicate)Predicates.equalTo((Object)true)).verify(ErrorType.BAD_REQUEST_ERROR, new Object[]{"Bad content fields format"});
    }

    private Map<String, String> getAttributesMapping(String[] attributes) {
        return Arrays.stream(attributes).collect(Collectors.toMap(it -> StringUtils.substringBefore((String)it, (String)":"), it -> StringUtils.substringAfter((String)it, (String)":")));
    }
}

