/*
 * Decompiled with CFR 0.152.
 */
package com.epam.ta.reportportal.core.statistics;

import com.epam.ta.reportportal.entity.enums.StatusEnum;
import com.epam.ta.reportportal.entity.enums.TestItemIssueGroup;
import com.epam.ta.reportportal.entity.statistics.Statistics;
import com.epam.ta.reportportal.entity.statistics.StatisticsField;
import com.epam.ta.reportportal.exception.ReportPortalException;
import com.epam.ta.reportportal.ws.model.ErrorType;
import java.util.Arrays;
import java.util.Optional;
import java.util.Set;
import java.util.function.Predicate;
import java.util.stream.Stream;

public final class StatisticsHelper {
    private static final String TOTAL = "statistics$executions$total";
    private static final String PASSED = "statistics$executions$passed";
    private static final String SKIPPED = "statistics$executions$skipped";
    private static final String FAILED = "statistics$executions$failed";
    private static final Predicate<Statistics> FAILED_PREDICATE = statistics -> {
        StatisticsField statisticsField = Optional.ofNullable(statistics.getStatisticsField()).orElseThrow(() -> new ReportPortalException(ErrorType.BAD_REQUEST_ERROR, new Object[]{"Statistics should contain a name field."}));
        String field = statisticsField.getName();
        Integer counter = statistics.getCounter();
        return (field.contains("failed") || field.contains("skipped") || field.contains("to_investigate")) && counter > 0;
    };

    private StatisticsHelper() {
    }

    public static StatusEnum getStatusFromStatistics(Set<Statistics> statistics) {
        return statistics.stream().anyMatch(FAILED_PREDICATE) ? StatusEnum.FAILED : StatusEnum.PASSED;
    }

    public static Integer extractStatisticsCount(String statisticsField, Set<Statistics> statistics) {
        return statistics.stream().filter(it -> it.getStatisticsField().getName().equalsIgnoreCase(statisticsField)).findFirst().orElse(new Statistics()).getCounter();
    }

    public static Stream<String> defaultStatisticsFields() {
        return Stream.concat(Arrays.stream(TestItemIssueGroup.values()).filter(value -> !value.getIssueCounterField().equalsIgnoreCase(TestItemIssueGroup.NOT_ISSUE_FLAG.getIssueCounterField())).map(value -> "statistics$defects$" + value.getValue().toLowerCase() + "$" + value.getLocator()), Stream.of(TOTAL, PASSED, SKIPPED, FAILED));
    }
}

