/*
 * Decompiled with CFR 0.152.
 */
package com.epam.ta.reportportal.core.project.impl;

import com.epam.ta.reportportal.commons.EntityUtils;
import com.epam.ta.reportportal.commons.Predicates;
import com.epam.ta.reportportal.commons.querygen.Condition;
import com.epam.ta.reportportal.commons.querygen.ConvertibleCondition;
import com.epam.ta.reportportal.commons.querygen.Filter;
import com.epam.ta.reportportal.commons.querygen.FilterCondition;
import com.epam.ta.reportportal.commons.querygen.Queryable;
import com.epam.ta.reportportal.core.project.GetProjectInfoHandler;
import com.epam.ta.reportportal.core.project.impl.ProjectInfoWidgetDataConverter;
import com.epam.ta.reportportal.dao.ActivityRepository;
import com.epam.ta.reportportal.dao.LaunchRepository;
import com.epam.ta.reportportal.dao.ProjectRepository;
import com.epam.ta.reportportal.dao.TicketRepository;
import com.epam.ta.reportportal.dao.UserRepository;
import com.epam.ta.reportportal.entity.activity.Activity;
import com.epam.ta.reportportal.entity.activity.ActivityAction;
import com.epam.ta.reportportal.entity.enums.InfoInterval;
import com.epam.ta.reportportal.entity.enums.LaunchModeEnum;
import com.epam.ta.reportportal.entity.launch.Launch;
import com.epam.ta.reportportal.entity.project.Project;
import com.epam.ta.reportportal.entity.project.ProjectInfo;
import com.epam.ta.reportportal.entity.project.email.ProjectInfoWidget;
import com.epam.ta.reportportal.entity.user.User;
import com.epam.ta.reportportal.exception.ReportPortalException;
import com.epam.ta.reportportal.ws.converter.PagedResourcesAssembler;
import com.epam.ta.reportportal.ws.converter.converters.ActivityConverter;
import com.epam.ta.reportportal.ws.converter.converters.LaunchConverter;
import com.epam.ta.reportportal.ws.converter.converters.ProjectSettingsConverter;
import com.epam.ta.reportportal.ws.model.ActivityResource;
import com.epam.ta.reportportal.ws.model.ErrorType;
import com.epam.ta.reportportal.ws.model.launch.Mode;
import com.epam.ta.reportportal.ws.model.project.LaunchesPerUser;
import com.epam.ta.reportportal.ws.model.project.ProjectInfoResource;
import com.google.common.collect.Lists;
import java.math.RoundingMode;
import java.sql.Timestamp;
import java.text.DecimalFormat;
import java.time.Clock;
import java.time.LocalDateTime;
import java.time.ZoneOffset;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.data.domain.Sort;
import org.springframework.stereotype.Service;

@Service
public class GetProjectInfoHandlerImpl
implements GetProjectInfoHandler {
    private static final Double WEEKS_IN_MONTH = 4.4;
    private static final int LIMIT = 150;
    private static final Predicate<ActivityAction> ACTIVITIES_PROJECT_FILTER = it -> it == ActivityAction.UPDATE_DEFECT || it == ActivityAction.DELETE_DEFECT || it == ActivityAction.LINK_ISSUE || it == ActivityAction.LINK_ISSUE_AA || it == ActivityAction.UNLINK_ISSUE || it == ActivityAction.UPDATE_ITEM;
    private final ProjectRepository projectRepository;
    private final LaunchRepository launchRepository;
    private final ActivityRepository activityRepository;
    private final ProjectInfoWidgetDataConverter dataConverter;
    private final LaunchConverter launchConverter;
    private final UserRepository userRepository;
    private final TicketRepository ticketRepository;
    private DecimalFormat formatter = new DecimalFormat("###.##");

    @Autowired
    public GetProjectInfoHandlerImpl(ProjectRepository projectRepository, LaunchRepository launchRepository, ActivityRepository activityRepository, ProjectInfoWidgetDataConverter dataConverter, LaunchConverter launchConverter, UserRepository userRepository, TicketRepository ticketRepository) {
        this.projectRepository = projectRepository;
        this.launchRepository = launchRepository;
        this.activityRepository = activityRepository;
        this.dataConverter = dataConverter;
        this.launchConverter = launchConverter;
        this.userRepository = userRepository;
        this.ticketRepository = ticketRepository;
    }

    private static LocalDateTime getStartIntervalDate(InfoInterval interval) {
        return LocalDateTime.now(Clock.systemUTC()).minusMonths(interval.getCount().intValue());
    }

    private static Filter projectInfoFilter(Project project, InfoInterval infoInterval) {
        return Filter.builder().withTarget(ProjectInfo.class).withCondition((ConvertibleCondition)new FilterCondition(Condition.EQUALS, false, project.getName(), "name")).withCondition((ConvertibleCondition)new FilterCondition(Condition.GREATER_THAN_OR_EQUALS, false, String.valueOf(GetProjectInfoHandlerImpl.getStartIntervalDate(infoInterval).toInstant(ZoneOffset.UTC).toEpochMilli()), "creationDate")).build();
    }

    @Override
    public Iterable<ProjectInfoResource> getAllProjectsInfo(Queryable filter, Pageable pageable) {
        return (Iterable)PagedResourcesAssembler.pageConverter(ProjectSettingsConverter.TO_PROJECT_INFO_RESOURCE).apply((Page<ProjectInfo>)this.projectRepository.findProjectInfoByFilter(filter, pageable));
    }

    @Override
    public ProjectInfoResource getProjectInfo(String projectName, String interval) {
        Project project = (Project)this.projectRepository.findByName(EntityUtils.normalizeId((String)projectName)).orElseThrow(() -> new ReportPortalException(ErrorType.PROJECT_NOT_FOUND, new Object[]{projectName}));
        InfoInterval infoInterval = (InfoInterval)InfoInterval.findByInterval((String)interval).orElseThrow(() -> new ReportPortalException(ErrorType.BAD_REQUEST_ERROR, new Object[]{interval}));
        Filter filter = Filter.builder().withTarget(ProjectInfo.class).withCondition((ConvertibleCondition)FilterCondition.builder().eq("name", project.getName()).build()).build();
        Page result = this.projectRepository.findProjectInfoByFilter((Queryable)filter, Pageable.unpaged());
        ProjectInfoResource projectInfoResource = ProjectSettingsConverter.TO_PROJECT_INFO_RESOURCE.apply((ProjectInfo)result.get().findFirst().orElseThrow(() -> new ReportPortalException(ErrorType.PROJECT_NOT_FOUND, new Object[]{projectName})));
        LocalDateTime startIntervalDate = GetProjectInfoHandlerImpl.getStartIntervalDate(infoInterval);
        Map countPerUser = this.launchRepository.countLaunchesGroupedByOwner(project.getId(), LaunchModeEnum.DEFAULT.toString(), startIntervalDate);
        projectInfoResource.setUniqueTickets(this.ticketRepository.findUniqueCountByProjectBefore(project.getId(), startIntervalDate));
        projectInfoResource.setLaunchesPerUser(countPerUser.entrySet().stream().map(e -> new LaunchesPerUser((String)e.getKey(), (Integer)e.getValue())).collect(Collectors.toList()));
        if (projectInfoResource.getLaunchesQuantity() != 0) {
            this.formatter.setRoundingMode(RoundingMode.HALF_UP);
            double value = (double)projectInfoResource.getLaunchesQuantity().intValue() / ((double)infoInterval.getCount().intValue() * WEEKS_IN_MONTH);
            projectInfoResource.setLaunchesPerWeek(this.formatter.format(value));
        } else {
            projectInfoResource.setLaunchesPerWeek(this.formatter.format(0L));
        }
        return projectInfoResource;
    }

    @Override
    public Map<String, ?> getProjectInfoWidgetContent(String projectName, String interval, String widgetCode) {
        Map<Object, Object> result;
        Project project = (Project)this.projectRepository.findByName(projectName).orElseThrow(() -> new ReportPortalException(ErrorType.PROJECT_NOT_FOUND, new Object[]{projectName}));
        InfoInterval infoInterval = (InfoInterval)InfoInterval.findByInterval((String)interval).orElseThrow(() -> new ReportPortalException(ErrorType.BAD_REQUEST_ERROR, new Object[]{interval}));
        ProjectInfoWidget widgetType = (ProjectInfoWidget)ProjectInfoWidget.findByCode((String)widgetCode).orElseThrow(() -> new ReportPortalException(ErrorType.BAD_REQUEST_ERROR, new Object[]{widgetCode}));
        List launches = this.launchRepository.findByProjectIdAndStartTimeGreaterThanAndMode(project.getId(), GetProjectInfoHandlerImpl.getStartIntervalDate(infoInterval), LaunchModeEnum.DEFAULT);
        switch (widgetType) {
            case INVESTIGATED: {
                result = this.dataConverter.getInvestigatedProjectInfo(launches, infoInterval);
                break;
            }
            case CASES_STATISTIC: {
                result = this.dataConverter.getTestCasesStatisticsProjectInfo(launches);
                break;
            }
            case LAUNCHES_QUANTITY: {
                result = this.dataConverter.getLaunchesQuantity(launches, infoInterval);
                break;
            }
            case ISSUES_CHART: {
                result = this.dataConverter.getLaunchesIssues(launches, infoInterval);
                break;
            }
            case ACTIVITIES: {
                result = this.getActivities(project, infoInterval);
                break;
            }
            case LAST_LAUNCH: {
                result = this.getLastLaunchStatistics(project.getId());
                break;
            }
            default: {
                result = Collections.emptyMap();
            }
        }
        return result;
    }

    private Map<String, ?> getLastLaunchStatistics(Long projectId) {
        Optional launchOptional = this.launchRepository.findLastRun(projectId, Mode.DEFAULT.name());
        return launchOptional.isPresent() ? Collections.singletonMap("result", this.launchConverter.TO_RESOURCE.apply((Launch)launchOptional.get())) : Collections.emptyMap();
    }

    private Map<String, List<ActivityResource>> getActivities(Project project, InfoInterval infoInterval) {
        String value = Arrays.stream(ActivityAction.values()).filter(Predicates.not(ACTIVITIES_PROJECT_FILTER)).map(ActivityAction::getValue).collect(Collectors.joining(","));
        Filter filter = new Filter(Activity.class, (List)Lists.newArrayList((Object[])new ConvertibleCondition[]{new FilterCondition(Condition.IN, false, value, "action"), new FilterCondition(Condition.EQUALS, false, String.valueOf(project.getId()), "projectId"), new FilterCondition(Condition.GREATER_THAN_OR_EQUALS, false, String.valueOf(Timestamp.valueOf(GetProjectInfoHandlerImpl.getStartIntervalDate(infoInterval)).getTime()), "creationDate")}));
        List activities = this.activityRepository.findByFilter((Queryable)filter, (Pageable)PageRequest.of((int)0, (int)150, (Sort)Sort.by((Sort.Direction)Sort.Direction.DESC, (String[])new String[]{"creationDate"}))).getContent();
        Map<Long, String> userIdLoginMapping = this.userRepository.findAllById((Iterable)activities.stream().filter(a -> a.getUserId() != null).map(Activity::getUserId).collect(Collectors.toSet())).stream().collect(Collectors.toMap(User::getId, User::getLogin));
        return Collections.singletonMap("result", activities.stream().map(a -> Optional.ofNullable(a.getUserId()).map(userId -> ActivityConverter.TO_RESOURCE_WITH_USER.apply((Activity)a, (String)userIdLoginMapping.get(userId))).orElseGet(() -> ActivityConverter.TO_RESOURCE.apply((Activity)a))).peek(resource -> resource.setProjectName(project.getName())).collect(Collectors.toList()));
    }
}

