/*
 * Decompiled with CFR 0.152.
 */
package com.epam.ta.reportportal.core.launch.rerun;

import com.epam.ta.reportportal.commons.ReportPortalUser;
import com.epam.ta.reportportal.core.events.MessageBus;
import com.epam.ta.reportportal.core.events.activity.LaunchStartedEvent;
import com.epam.ta.reportportal.core.events.item.ItemRetryEvent;
import com.epam.ta.reportportal.core.item.UniqueIdGenerator;
import com.epam.ta.reportportal.core.launch.rerun.RerunHandler;
import com.epam.ta.reportportal.dao.LaunchRepository;
import com.epam.ta.reportportal.dao.TestItemRepository;
import com.epam.ta.reportportal.entity.enums.LaunchModeEnum;
import com.epam.ta.reportportal.entity.enums.StatusEnum;
import com.epam.ta.reportportal.entity.enums.TestItemTypeEnum;
import com.epam.ta.reportportal.entity.item.Parameter;
import com.epam.ta.reportportal.entity.item.TestItem;
import com.epam.ta.reportportal.entity.launch.Launch;
import com.epam.ta.reportportal.exception.ReportPortalException;
import com.epam.ta.reportportal.ws.converter.builders.TestItemBuilder;
import com.epam.ta.reportportal.ws.converter.converters.ItemAttributeConverter;
import com.epam.ta.reportportal.ws.converter.converters.LaunchConverter;
import com.epam.ta.reportportal.ws.converter.converters.ParametersConverter;
import com.epam.ta.reportportal.ws.model.ErrorType;
import com.epam.ta.reportportal.ws.model.ParameterResource;
import com.epam.ta.reportportal.ws.model.StartTestItemRQ;
import com.epam.ta.reportportal.ws.model.attribute.ItemAttributesRQ;
import com.epam.ta.reportportal.ws.model.item.ItemCreatedRS;
import com.epam.ta.reportportal.ws.model.launch.StartLaunchRQ;
import com.epam.ta.reportportal.ws.model.launch.StartLaunchRS;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.ApplicationEventPublisher;
import org.springframework.stereotype.Component;

@Component
public class RerunHandlerImpl
implements RerunHandler {
    private final TestItemRepository testItemRepository;
    private final LaunchRepository launchRepository;
    private final UniqueIdGenerator uniqueIdGenerator;
    private final MessageBus messageBus;
    private final ApplicationEventPublisher eventPublisher;

    @Autowired
    public RerunHandlerImpl(TestItemRepository testItemRepository, LaunchRepository launchRepository, UniqueIdGenerator uniqueIdGenerator, MessageBus messageBus, ApplicationEventPublisher eventPublisher) {
        this.testItemRepository = testItemRepository;
        this.launchRepository = launchRepository;
        this.uniqueIdGenerator = uniqueIdGenerator;
        this.messageBus = messageBus;
        this.eventPublisher = eventPublisher;
    }

    @Override
    public StartLaunchRS handleLaunch(StartLaunchRQ request, Long projectId, ReportPortalUser user) {
        Optional launchOptional = StringUtils.isEmpty((CharSequence)request.getRerunOf()) ? this.launchRepository.findLatestByNameAndProjectId(request.getName(), projectId) : this.launchRepository.findByUuid(request.getRerunOf());
        Launch launch = (Launch)launchOptional.orElseThrow(() -> new ReportPortalException(ErrorType.LAUNCH_NOT_FOUND, new Object[]{Optional.ofNullable(request.getRerunOf()).orElse(request.getName())}));
        Optional.ofNullable(request.getMode()).map(it -> LaunchModeEnum.valueOf((String)it.name())).ifPresent(arg_0 -> ((Launch)launch).setMode(arg_0));
        Optional.ofNullable(request.getDescription()).ifPresent(arg_0 -> ((Launch)launch).setDescription(arg_0));
        launch.setStatus(StatusEnum.IN_PROGRESS);
        Optional.ofNullable(request.getAttributes()).map(it -> it.stream().map(attr -> ItemAttributeConverter.TO_LAUNCH_ATTRIBUTE.apply((ItemAttributesRQ)attr, launch)).collect(Collectors.toSet())).ifPresent(arg_0 -> ((Launch)launch).setAttributes(arg_0));
        Optional.ofNullable(request.getUuid()).ifPresent(arg_0 -> ((Launch)launch).setUuid(arg_0));
        launch.setRerun(true);
        this.messageBus.publishActivity(new LaunchStartedEvent(LaunchConverter.TO_ACTIVITY_RESOURCE.apply(launch), user.getUserId(), user.getUsername()));
        StartLaunchRS response = new StartLaunchRS();
        response.setId(launch.getUuid());
        response.setNumber(launch.getNumber());
        return response;
    }

    @Override
    public Optional<ItemCreatedRS> handleRootItem(StartTestItemRQ request, Launch launch) {
        Optional itemOptional = this.testItemRepository.findByNameAndLaunchWithoutParents(request.getName(), launch.getId());
        if (!itemOptional.isPresent()) {
            return Optional.empty();
        }
        if (!this.isParametersEqual(request.getParameters(), ((TestItem)itemOptional.get()).getParameters())) {
            return Optional.empty();
        }
        TestItem item = this.handleRerun(request, launch, (TestItem)itemOptional.get(), null);
        return Optional.of(new ItemCreatedRS(item.getUuid(), item.getUniqueId()));
    }

    @Override
    public Optional<ItemCreatedRS> handleChildItem(StartTestItemRQ request, Launch launch, TestItem parent) {
        Optional itemOptional = this.testItemRepository.findByNameAndLaunchUnderPath(request.getName(), launch.getId(), parent.getPath());
        if (!itemOptional.isPresent()) {
            return Optional.empty();
        }
        if (!this.isParametersEqual(request.getParameters(), ((TestItem)itemOptional.get()).getParameters())) {
            return Optional.empty();
        }
        TestItem item = this.handleRerun(request, launch, (TestItem)itemOptional.get(), parent);
        return Optional.of(new ItemCreatedRS(item.getUuid(), item.getUniqueId()));
    }

    private boolean isParametersEqual(List<ParameterResource> fromRequest, Set<Parameter> stored) {
        Set requestParameters = Optional.ofNullable(fromRequest).map(it -> it.stream().map(ParametersConverter.TO_MODEL).collect(Collectors.toSet())).orElse(Collections.emptySet());
        return stored.equals(requestParameters);
    }

    private TestItem handleRerun(StartTestItemRQ request, Launch launch, TestItem testItem, TestItem parent) {
        TestItem item = testItem;
        item.getItemResults().setStatus(StatusEnum.IN_PROGRESS);
        item.setDescription(request.getDescription());
        if (item.getType().sameLevel(TestItemTypeEnum.STEP)) {
            this.eventPublisher.publishEvent((Object)new ItemRetryEvent(launch.getProjectId(), item.getItemId()));
            item = this.makeRetry(request, launch, parent);
        }
        Optional.ofNullable(request.getUuid()).ifPresent(arg_0 -> ((TestItem)item).setUuid(arg_0));
        return item;
    }

    private TestItem makeRetry(StartTestItemRQ request, Launch launch, TestItem parent) {
        TestItem retry = new TestItemBuilder().addLaunchId(launch.getId()).addStartItemRequest(request).addAttributes(request.getAttributes()).addParent(parent).get();
        this.testItemRepository.save((Object)retry);
        this.generateUniqueId(launch, retry, Optional.ofNullable(parent).map(it -> it.getPath() + "." + retry.getItemId()).orElse(String.valueOf(retry.getItemId())));
        this.handleRetries(launch, retry);
        return retry;
    }

    private void generateUniqueId(Launch launch, TestItem item, String path) {
        item.setPath(path);
        if (null == item.getUniqueId()) {
            item.setUniqueId(this.uniqueIdGenerator.generate(item, launch));
        }
    }

    private void handleRetries(Launch launch, TestItem item) {
        this.testItemRepository.handleRetries(item.getItemId());
        if (!launch.isHasRetries()) {
            launch.setHasRetries(this.launchRepository.hasRetries(launch.getId()));
        }
    }
}

