/*
 * Decompiled with CFR 0.152.
 */
package com.epam.ta.reportportal.core.jasper.impl;

import com.epam.ta.reportportal.commons.validation.BusinessRule;
import com.epam.ta.reportportal.commons.validation.Suppliers;
import com.epam.ta.reportportal.core.jasper.GetJasperReportHandler;
import com.epam.ta.reportportal.entity.jasper.ReportFormat;
import com.epam.ta.reportportal.exception.ReportPortalException;
import com.epam.ta.reportportal.ws.model.ErrorType;
import java.io.OutputStream;
import java.util.Set;
import net.sf.jasperreports.engine.JRException;
import net.sf.jasperreports.engine.JasperExportManager;
import net.sf.jasperreports.engine.JasperPrint;
import net.sf.jasperreports.engine.export.HtmlExporter;
import net.sf.jasperreports.engine.export.JRCsvExporter;
import net.sf.jasperreports.engine.export.JRXlsExporter;
import net.sf.jasperreports.export.ExporterConfiguration;
import net.sf.jasperreports.export.ExporterInput;
import net.sf.jasperreports.export.ExporterOutput;
import net.sf.jasperreports.export.ReportExportConfiguration;
import net.sf.jasperreports.export.SimpleCsvExporterConfiguration;
import net.sf.jasperreports.export.SimpleExporterInput;
import net.sf.jasperreports.export.SimpleHtmlExporterOutput;
import net.sf.jasperreports.export.SimpleHtmlReportConfiguration;
import net.sf.jasperreports.export.SimpleOutputStreamExporterOutput;
import net.sf.jasperreports.export.SimpleWriterExporterOutput;
import net.sf.jasperreports.export.SimpleXlsReportConfiguration;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractJasperReportHandler<T>
implements GetJasperReportHandler<T> {
    private static final Logger LOGGER = LoggerFactory.getLogger(AbstractJasperReportHandler.class);
    private final String unsupportedReportFormatExceptionMessage;

    public AbstractJasperReportHandler(String unsupportedReportFormatExceptionMessage) {
        this.unsupportedReportFormatExceptionMessage = unsupportedReportFormatExceptionMessage;
    }

    @Override
    public ReportFormat getReportFormat(String view) {
        ReportFormat reportFormat = (ReportFormat)ReportFormat.findByName((String)view).orElseThrow(() -> new ReportPortalException(ErrorType.BAD_REQUEST_ERROR, new Object[]{Suppliers.formattedSupplier((String)"Unexpected report format: {}", (Object[])new Object[]{view})}));
        BusinessRule.expect((Object)reportFormat, this.getAvailableReportFormats()::contains).verify(ErrorType.BAD_REQUEST_ERROR, new Object[]{Suppliers.formattedSupplier((String)this.unsupportedReportFormatExceptionMessage, (Object[])new Object[]{reportFormat.name()})});
        return reportFormat;
    }

    @Override
    public void writeReport(ReportFormat format, OutputStream outputStream, JasperPrint jasperPrint) {
        try {
            switch (format) {
                case PDF: {
                    JasperExportManager.exportReportToPdfStream((JasperPrint)jasperPrint, (OutputStream)outputStream);
                    break;
                }
                case HTML: {
                    HtmlExporter exporter = new HtmlExporter();
                    exporter.setExporterInput((ExporterInput)new SimpleExporterInput(jasperPrint));
                    SimpleHtmlExporterOutput exporterOutput = new SimpleHtmlExporterOutput(outputStream);
                    exporter.setExporterOutput((ExporterOutput)exporterOutput);
                    SimpleHtmlReportConfiguration htmlConfig = new SimpleHtmlReportConfiguration();
                    htmlConfig.setWhitePageBackground(Boolean.valueOf(false));
                    htmlConfig.setRemoveEmptySpaceBetweenRows(Boolean.valueOf(true));
                    exporter.setConfiguration((ReportExportConfiguration)htmlConfig);
                    exporter.exportReport();
                    break;
                }
                case XLS: {
                    SimpleXlsReportConfiguration configuration = new SimpleXlsReportConfiguration();
                    configuration.setOnePagePerSheet(Boolean.valueOf(false));
                    configuration.setDetectCellType(Boolean.valueOf(true));
                    configuration.setCollapseRowSpan(Boolean.valueOf(false));
                    configuration.setIgnoreGraphics(Boolean.valueOf(true));
                    JRXlsExporter exporterXLS = new JRXlsExporter();
                    exporterXLS.setExporterInput((ExporterInput)new SimpleExporterInput(jasperPrint));
                    exporterXLS.setExporterOutput((ExporterOutput)new SimpleOutputStreamExporterOutput(outputStream));
                    exporterXLS.setConfiguration((ReportExportConfiguration)configuration);
                    exporterXLS.exportReport();
                    break;
                }
                case CSV: {
                    JRCsvExporter jrCsvExporter = new JRCsvExporter();
                    jrCsvExporter.setExporterInput((ExporterInput)new SimpleExporterInput(jasperPrint));
                    jrCsvExporter.setExporterOutput((ExporterOutput)new SimpleWriterExporterOutput(outputStream));
                    SimpleCsvExporterConfiguration csvExporterConfiguration = new SimpleCsvExporterConfiguration();
                    jrCsvExporter.setConfiguration((ExporterConfiguration)csvExporterConfiguration);
                    jrCsvExporter.exportReport();
                    break;
                }
                default: {
                    throw new UnsupportedOperationException(format.getValue());
                }
            }
        }
        catch (JRException ex) {
            LOGGER.error("Unable to generate report!", (Throwable)ex);
            BusinessRule.fail().withError(ErrorType.FORBIDDEN_OPERATION, new Object[]{Suppliers.formattedSupplier((String)" Unexpected issue during report output stream creation: {}", (Object[])new Object[]{ex.getLocalizedMessage()})});
        }
    }

    public abstract Set<ReportFormat> getAvailableReportFormats();
}

