/*
 * Decompiled with CFR 0.152.
 */
package com.epam.ta.reportportal.core.item.impl.status;

import com.epam.ta.reportportal.commons.Preconditions;
import com.epam.ta.reportportal.commons.ReportPortalUser;
import com.epam.ta.reportportal.commons.validation.BusinessRule;
import com.epam.ta.reportportal.core.events.MessageBus;
import com.epam.ta.reportportal.core.events.activity.TestItemStatusChangedEvent;
import com.epam.ta.reportportal.core.item.impl.IssueTypeHandler;
import com.epam.ta.reportportal.core.item.impl.status.StatusChangingStrategy;
import com.epam.ta.reportportal.dao.IssueEntityRepository;
import com.epam.ta.reportportal.dao.ItemAttributeRepository;
import com.epam.ta.reportportal.dao.LaunchRepository;
import com.epam.ta.reportportal.dao.TestItemRepository;
import com.epam.ta.reportportal.entity.ItemAttribute;
import com.epam.ta.reportportal.entity.enums.StatusEnum;
import com.epam.ta.reportportal.entity.item.TestItem;
import com.epam.ta.reportportal.ws.converter.converters.TestItemConverter;
import com.epam.ta.reportportal.ws.model.ErrorType;
import com.epam.ta.reportportal.ws.model.activity.TestItemActivityResource;
import java.util.Optional;
import java.util.function.Predicate;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class FromPassedStatusChangingStrategy
extends StatusChangingStrategy {
    @Autowired
    public FromPassedStatusChangingStrategy(TestItemRepository testItemRepository, ItemAttributeRepository itemAttributeRepository, IssueTypeHandler issueTypeHandler, IssueEntityRepository issueEntityRepository, LaunchRepository launchRepository, MessageBus messageBus) {
        super(testItemRepository, itemAttributeRepository, issueTypeHandler, issueEntityRepository, launchRepository, messageBus);
    }

    @Override
    public void changeStatus(TestItem item, StatusEnum providedStatus, ReportPortalUser user, Long projectId) {
        BusinessRule.expect((Object)providedStatus, (Predicate)Preconditions.statusIn((StatusEnum[])new StatusEnum[]{StatusEnum.SKIPPED, StatusEnum.FAILED})).verify(ErrorType.INCORRECT_REQUEST, new Object[]{"Actual status: " + item.getItemResults().getStatus() + " can be switched only to: " + StatusEnum.SKIPPED + " or " + StatusEnum.FAILED});
        StatusEnum oldParentStatus = item.getParent().getItemResults().getStatus();
        TestItemActivityResource before = TestItemConverter.TO_ACTIVITY_RESOURCE.apply(item, projectId);
        Optional skippedIssueAttribute = this.itemAttributeRepository.findByLaunchIdAndKeyAndSystem(item.getLaunchId(), "skippedIssue", true);
        item.getItemResults().setStatus(providedStatus);
        if (StatusEnum.FAILED.equals((Object)providedStatus) || StatusEnum.SKIPPED.equals((Object)providedStatus) && skippedIssueAttribute.isPresent() && ((ItemAttribute)skippedIssueAttribute.get()).getValue().equals("true")) {
            this.addToInvestigateIssue(item, projectId);
        }
        this.messageBus.publishActivity(new TestItemStatusChangedEvent(before, TestItemConverter.TO_ACTIVITY_RESOURCE.apply(item, projectId), user.getUserId(), user.getUsername()));
        this.changeParentsStatusesToFailed(item, oldParentStatus, user, projectId);
    }
}

