/*
 * Decompiled with CFR 0.152.
 */
package com.epam.ta.reportportal.core.item.impl.status;

import com.epam.ta.reportportal.commons.ReportPortalUser;
import com.epam.ta.reportportal.core.events.MessageBus;
import com.epam.ta.reportportal.core.events.activity.TestItemStatusChangedEvent;
import com.epam.ta.reportportal.core.item.impl.status.ChangeStatusHandler;
import com.epam.ta.reportportal.dao.IssueEntityRepository;
import com.epam.ta.reportportal.dao.LaunchRepository;
import com.epam.ta.reportportal.dao.TestItemRepository;
import com.epam.ta.reportportal.entity.enums.StatusEnum;
import com.epam.ta.reportportal.entity.item.TestItem;
import com.epam.ta.reportportal.entity.item.issue.IssueEntity;
import com.epam.ta.reportportal.entity.launch.Launch;
import com.epam.ta.reportportal.jooq.enums.JStatusEnum;
import com.epam.ta.reportportal.ws.converter.converters.TestItemConverter;
import com.epam.ta.reportportal.ws.model.activity.TestItemActivityResource;
import com.google.common.collect.Lists;
import java.util.List;
import java.util.Optional;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class ChangeStatusHandlerImpl
implements ChangeStatusHandler {
    private final TestItemRepository testItemRepository;
    private final IssueEntityRepository issueEntityRepository;
    private final MessageBus messageBus;
    private final LaunchRepository launchRepository;

    @Autowired
    public ChangeStatusHandlerImpl(TestItemRepository testItemRepository, IssueEntityRepository issueEntityRepository, MessageBus messageBus, LaunchRepository launchRepository) {
        this.testItemRepository = testItemRepository;
        this.issueEntityRepository = issueEntityRepository;
        this.messageBus = messageBus;
        this.launchRepository = launchRepository;
    }

    @Override
    public void changeParentStatus(Long childId, Long projectId, ReportPortalUser user) {
        this.testItemRepository.findParentByChildId(childId).ifPresent(parent -> {
            if (parent.isHasChildren()) {
                Optional.ofNullable(parent.getItemResults().getIssue()).map(IssueEntity::getIssueId).ifPresent(arg_0 -> ((IssueEntityRepository)this.issueEntityRepository).deleteById(arg_0));
            }
            if (this.isParentStatusUpdateRequired((TestItem)parent)) {
                StatusEnum resolvedStatus = this.resolveStatus(parent.getItemId());
                if (parent.getItemResults().getStatus() != resolvedStatus) {
                    TestItemActivityResource before = TestItemConverter.TO_ACTIVITY_RESOURCE.apply((TestItem)parent, projectId);
                    parent.getItemResults().setStatus(resolvedStatus);
                    this.messageBus.publishActivity(new TestItemStatusChangedEvent(before, TestItemConverter.TO_ACTIVITY_RESOURCE.apply((TestItem)parent, projectId), user.getUserId(), user.getUsername()));
                    this.changeParentStatus(parent.getItemId(), projectId, user);
                }
            }
        });
    }

    @Override
    public void changeLaunchStatus(Launch launch) {
        if (launch.getStatus() != StatusEnum.IN_PROGRESS && !this.launchRepository.hasItemsInStatuses(launch.getId(), (List)Lists.newArrayList((Object[])new JStatusEnum[]{JStatusEnum.IN_PROGRESS}))) {
            StatusEnum launchStatus = this.launchRepository.hasItemsWithStatusNotEqual(launch.getId(), StatusEnum.PASSED) ? StatusEnum.FAILED : StatusEnum.PASSED;
            launch.setStatus(launchStatus);
        }
    }

    private boolean isParentStatusUpdateRequired(TestItem parent) {
        return parent.getItemResults().getStatus() != StatusEnum.IN_PROGRESS && this.testItemRepository.hasItemsInStatusByParent(parent.getItemId(), parent.getPath(), new StatusEnum[]{StatusEnum.IN_PROGRESS}) == false;
    }

    private StatusEnum resolveStatus(Long itemId) {
        return this.testItemRepository.hasDescendantsWithStatusNotEqual(itemId, JStatusEnum.PASSED) ? StatusEnum.FAILED : StatusEnum.PASSED;
    }
}

