/*
 * Decompiled with CFR 0.152.
 */
package com.epam.ta.reportportal.core.item.impl;

import com.epam.ta.reportportal.core.item.UniqueIdGenerator;
import com.epam.ta.reportportal.dao.TestItemRepository;
import com.epam.ta.reportportal.entity.item.TestItem;
import com.epam.ta.reportportal.entity.launch.Launch;
import com.google.common.base.Strings;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Set;
import java.util.StringJoiner;
import java.util.stream.Collectors;
import org.apache.commons.codec.digest.DigestUtils;
import org.apache.commons.collections.CollectionUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class TestItemUniqueIdGenerator
implements UniqueIdGenerator {
    private static final String TRAIT = "auto:";
    private TestItemRepository testItemRepository;

    @Autowired
    public void setTestItemRepository(TestItemRepository testItemRepository) {
        this.testItemRepository = testItemRepository;
    }

    @Override
    public String generate(TestItem testItem, Launch launch) {
        String forEncoding = this.prepareForEncoding(testItem, launch);
        return TRAIT + DigestUtils.md5Hex((String)forEncoding);
    }

    @Override
    public boolean validate(String encoded) {
        return !Strings.isNullOrEmpty((String)encoded) && encoded.startsWith(TRAIT);
    }

    private String prepareForEncoding(TestItem testItem, Launch launch) {
        Long projectId = launch.getProjectId();
        String launchName = launch.getName();
        ArrayList pathNames = new ArrayList(this.testItemRepository.selectPathNames(testItem.getPath()).values());
        String itemName = testItem.getName();
        StringJoiner joiner = new StringJoiner(";");
        joiner.add(projectId.toString()).add(launchName);
        if (!CollectionUtils.isEmpty(pathNames)) {
            joiner.add(String.join((CharSequence)";", pathNames));
        }
        joiner.add(itemName);
        Set parameters = testItem.getParameters();
        if (!CollectionUtils.isEmpty((Collection)parameters)) {
            joiner.add(parameters.stream().map(parameter -> (!Strings.isNullOrEmpty((String)parameter.getKey()) ? parameter.getKey() + "=" : "") + parameter.getValue()).collect(Collectors.joining(",")));
        }
        return joiner.toString();
    }
}

