/*
 * Decompiled with CFR 0.152.
 */
package com.epam.ta.reportportal.core.item.impl;

import com.epam.ta.reportportal.commons.Preconditions;
import com.epam.ta.reportportal.commons.Predicates;
import com.epam.ta.reportportal.commons.ReportPortalUser;
import com.epam.ta.reportportal.commons.validation.BusinessRule;
import com.epam.ta.reportportal.commons.validation.Suppliers;
import com.epam.ta.reportportal.core.events.item.ItemRetryEvent;
import com.epam.ta.reportportal.core.item.StartTestItemHandler;
import com.epam.ta.reportportal.core.item.UniqueIdGenerator;
import com.epam.ta.reportportal.core.launch.rerun.RerunHandler;
import com.epam.ta.reportportal.dao.LaunchRepository;
import com.epam.ta.reportportal.dao.TestItemRepository;
import com.epam.ta.reportportal.entity.item.TestItem;
import com.epam.ta.reportportal.entity.launch.Launch;
import com.epam.ta.reportportal.entity.user.UserRole;
import com.epam.ta.reportportal.exception.ReportPortalException;
import com.epam.ta.reportportal.ws.converter.builders.TestItemBuilder;
import com.epam.ta.reportportal.ws.model.ErrorType;
import com.epam.ta.reportportal.ws.model.StartTestItemRQ;
import com.epam.ta.reportportal.ws.model.item.ItemCreatedRS;
import java.time.LocalDateTime;
import java.util.Optional;
import java.util.function.Predicate;
import org.apache.commons.lang3.BooleanUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.ApplicationEventPublisher;
import org.springframework.context.annotation.Primary;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
@Primary
@Transactional
class StartTestItemHandlerImpl
implements StartTestItemHandler {
    private static final Logger LOGGER = LoggerFactory.getLogger(StartTestItemHandlerImpl.class);
    private final TestItemRepository testItemRepository;
    private final LaunchRepository launchRepository;
    private final UniqueIdGenerator identifierGenerator;
    private final RerunHandler rerunHandler;
    private final ApplicationEventPublisher eventPublisher;

    @Autowired
    public StartTestItemHandlerImpl(TestItemRepository testItemRepository, LaunchRepository launchRepository, UniqueIdGenerator identifierGenerator, RerunHandler rerunHandler, ApplicationEventPublisher eventPublisher) {
        this.testItemRepository = testItemRepository;
        this.launchRepository = launchRepository;
        this.identifierGenerator = identifierGenerator;
        this.rerunHandler = rerunHandler;
        this.eventPublisher = eventPublisher;
    }

    @Override
    public ItemCreatedRS startRootItem(ReportPortalUser user, ReportPortalUser.ProjectDetails projectDetails, StartTestItemRQ rq) {
        Optional<ItemCreatedRS> rerunCreatedRs;
        Launch launch = (Launch)this.launchRepository.findByUuidForUpdate(rq.getLaunchUuid()).orElseThrow(() -> new ReportPortalException(ErrorType.LAUNCH_NOT_FOUND, new Object[]{rq.getLaunchUuid()}));
        this.validate(user, projectDetails, rq, launch);
        if (launch.isRerun() && (rerunCreatedRs = this.rerunHandler.handleRootItem(rq, launch)).isPresent()) {
            return rerunCreatedRs.get();
        }
        TestItem item = new TestItemBuilder().addStartItemRequest(rq).addAttributes(rq.getAttributes()).addLaunchId(launch.getId()).get();
        this.testItemRepository.save((Object)item);
        this.generateUniqueId(launch, item, String.valueOf(item.getItemId()));
        LOGGER.debug("Created new root TestItem {}", (Object)item.getUuid());
        return new ItemCreatedRS(item.getUuid(), item.getUniqueId());
    }

    @Override
    public ItemCreatedRS startChildItem(ReportPortalUser user, ReportPortalUser.ProjectDetails projectDetails, StartTestItemRQ rq, String parentId) {
        Optional<ItemCreatedRS> rerunCreatedRs;
        boolean isRetry = BooleanUtils.toBoolean((Boolean)rq.isRetry());
        Launch launch = isRetry ? (Launch)this.launchRepository.findByUuidForUpdate(rq.getLaunchUuid()).orElseThrow(() -> new ReportPortalException(ErrorType.LAUNCH_NOT_FOUND, new Object[]{rq.getLaunchUuid()})) : (Launch)this.launchRepository.findByUuid(rq.getLaunchUuid()).orElseThrow(() -> new ReportPortalException(ErrorType.LAUNCH_NOT_FOUND, new Object[]{rq.getLaunchUuid()}));
        TestItem parentItem = (TestItem)this.testItemRepository.findByUuid(parentId).orElseThrow(() -> new ReportPortalException(ErrorType.TEST_ITEM_NOT_FOUND, new Object[]{parentId}));
        this.validate(rq, parentItem);
        if (launch.isRerun() && (rerunCreatedRs = this.rerunHandler.handleChildItem(rq, launch, parentItem)).isPresent()) {
            return rerunCreatedRs.get();
        }
        TestItem item = new TestItemBuilder().addStartItemRequest(rq).addAttributes(rq.getAttributes()).addLaunchId(launch.getId()).addParent(parentItem).get();
        this.testItemRepository.save((Object)item);
        this.generateUniqueId(launch, item, parentItem.getPath() + "." + item.getItemId());
        if (rq.isHasStats() && !parentItem.isHasChildren()) {
            parentItem.setHasChildren(true);
        }
        if (isRetry) {
            this.handleRetries(launch, item);
        }
        LOGGER.debug("Created new child TestItem {} with root {}", (Object)item.getUuid(), (Object)parentId);
        return new ItemCreatedRS(item.getUuid(), item.getUniqueId());
    }

    private void generateUniqueId(Launch launch, TestItem item, String path) {
        item.setPath(path);
        if (null == item.getUniqueId()) {
            item.setUniqueId(this.identifierGenerator.generate(item, launch));
        }
        if (null == item.getTestCaseId()) {
            item.setTestCaseHash(Integer.valueOf(item.getUniqueId().hashCode()));
        }
    }

    private void handleRetries(Launch launch, TestItem item) {
        this.testItemRepository.handleRetries(item.getItemId());
        this.eventPublisher.publishEvent((Object)new ItemRetryEvent(launch.getProjectId(), item.getItemId()));
        if (!launch.isHasRetries()) {
            launch.setHasRetries(this.launchRepository.hasRetries(launch.getId()));
        }
    }

    private void validate(ReportPortalUser user, ReportPortalUser.ProjectDetails projectDetails, StartTestItemRQ rq, Launch launch) {
        if (!UserRole.ADMINISTRATOR.equals((Object)user.getUserRole())) {
            BusinessRule.expect((Object)projectDetails.getProjectId(), (Predicate)Predicates.equalTo((Object)launch.getProjectId())).verify(ErrorType.ACCESS_DENIED, new Object[0]);
        }
        BusinessRule.expect((Object)rq.getStartTime(), (Predicate)Preconditions.sameTimeOrLater((LocalDateTime)launch.getStartTime())).verify(ErrorType.CHILD_START_TIME_EARLIER_THAN_PARENT, new Object[]{rq.getStartTime(), launch.getStartTime(), launch.getId()});
        BusinessRule.expect((Object)BooleanUtils.isTrue((Boolean)BooleanUtils.toBoolean((Boolean)rq.isRetry())), (Predicate)Predicates.equalTo((Object)false)).verify(ErrorType.BAD_REQUEST_ERROR, new Object[]{"Root test item can't be a retry."});
    }

    private void validate(StartTestItemRQ rq, TestItem parent) {
        if (!parent.isHasStats()) {
            BusinessRule.expect((Object)rq.isHasStats(), (Predicate)Predicates.equalTo((Object)Boolean.FALSE)).verify(ErrorType.BAD_REQUEST_ERROR, new Object[]{Suppliers.formattedSupplier((String)"Unable to add a not nested step item, because parent item with ID = '{}' is a nested step", (Object[])new Object[]{parent.getItemId()}).get()});
        }
        if (rq.isHasStats()) {
            BusinessRule.expect((Object)parent.getRetryOf(), Predicates.isNull()::test).verify(ErrorType.UNABLE_TO_SAVE_CHILD_ITEM_FOR_THE_RETRY, new Object[]{parent.getItemId()});
        }
        BusinessRule.expect((Object)rq.getStartTime(), (Predicate)Preconditions.sameTimeOrLater((LocalDateTime)parent.getStartTime())).verify(ErrorType.CHILD_START_TIME_EARLIER_THAN_PARENT, new Object[]{rq.getStartTime(), parent.getStartTime(), parent.getItemId()});
    }
}

