/*
 * Decompiled with CFR 0.152.
 */
package com.epam.ta.reportportal.core.item.impl;

import com.epam.ta.reportportal.commons.EntityUtils;
import com.epam.ta.reportportal.commons.validation.Suppliers;
import com.epam.ta.reportportal.dao.TestItemRepository;
import com.epam.ta.reportportal.entity.item.issue.IssueType;
import com.epam.ta.reportportal.exception.ReportPortalException;
import com.epam.ta.reportportal.ws.model.ErrorType;
import java.util.Optional;
import java.util.stream.Collectors;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class IssueTypeHandler {
    private TestItemRepository testItemRepository;

    @Autowired
    public void setTestItemRepository(TestItemRepository testItemRepository) {
        this.testItemRepository = testItemRepository;
    }

    public IssueType defineIssueType(Long projectId, String locator) {
        return (IssueType)this.testItemRepository.selectIssueTypeByLocator(projectId, Optional.ofNullable(locator).map(EntityUtils::normalizeId).orElseThrow(() -> new ReportPortalException("Locator should not be null"))).orElseThrow(() -> new ReportPortalException(ErrorType.FAILED_TEST_ITEM_ISSUE_TYPE_DEFINITION, new Object[]{Suppliers.formattedSupplier((String)"Invalid test item issue type definition '{}' is requested. Valid issue types' locators are: {}", (Object[])new Object[]{locator, this.testItemRepository.selectIssueLocatorsByProject(projectId).stream().map(IssueType::getLocator).collect(Collectors.toList())})}));
    }
}

