/*
 * Decompiled with CFR 0.152.
 */
package com.epam.ta.reportportal.core.integration.util;

import com.epam.ta.reportportal.commons.validation.BusinessRule;
import com.epam.ta.reportportal.commons.validation.Suppliers;
import com.epam.ta.reportportal.core.admin.ServerAdminHandlerImpl;
import com.epam.ta.reportportal.core.integration.util.BasicIntegrationServiceImpl;
import com.epam.ta.reportportal.core.plugin.PluginBox;
import com.epam.ta.reportportal.dao.IntegrationRepository;
import com.epam.ta.reportportal.entity.EmailSettingsEnum;
import com.epam.ta.reportportal.entity.integration.Integration;
import com.epam.ta.reportportal.exception.ReportPortalException;
import com.epam.ta.reportportal.util.email.EmailService;
import com.epam.ta.reportportal.util.email.MailServiceFactory;
import com.epam.ta.reportportal.ws.model.ErrorType;
import com.google.common.collect.Maps;
import com.mchange.lang.IntegerUtils;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.function.Supplier;
import javax.mail.MessagingException;
import org.apache.commons.collections.MapUtils;
import org.apache.commons.lang3.BooleanUtils;
import org.jasypt.util.text.BasicTextEncryptor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service
public class EmailServerIntegrationService
extends BasicIntegrationServiceImpl {
    private static final Logger LOGGER = LoggerFactory.getLogger(ServerAdminHandlerImpl.class);
    private BasicTextEncryptor basicTextEncryptor;
    private MailServiceFactory emailServiceFactory;

    public EmailServerIntegrationService(IntegrationRepository integrationRepository, PluginBox pluginBox, BasicTextEncryptor basicTextEncryptor, MailServiceFactory emailServiceFactory) {
        super(integrationRepository, pluginBox);
        this.basicTextEncryptor = basicTextEncryptor;
        this.emailServiceFactory = emailServiceFactory;
    }

    @Override
    public Map<String, Object> retrieveIntegrationParams(Map<String, Object> integrationParams) {
        BusinessRule.expect(integrationParams, MapUtils::isNotEmpty).verify(ErrorType.BAD_REQUEST_ERROR, new Object[]{"No integration params provided"});
        HashMap resultParams = Maps.newHashMapWithExpectedSize((int)EmailSettingsEnum.values().length);
        Optional fromAttribute = EmailSettingsEnum.FROM.getAttribute(integrationParams);
        fromAttribute.ifPresent(from -> resultParams.put(EmailSettingsEnum.FROM.getAttribute(), from));
        Optional.ofNullable(integrationParams.get(EmailSettingsEnum.PORT.getAttribute())).ifPresent(p -> {
            int port = IntegerUtils.parseInt((String)String.valueOf(p), (int)-1);
            if (port <= 0 || port > 65535) {
                BusinessRule.fail().withError(ErrorType.INCORRECT_REQUEST, new Object[]{"Incorrect 'Port' value. Allowed value is [1..65535]"});
            }
            resultParams.put(EmailSettingsEnum.PORT.getAttribute(), p);
        });
        EmailSettingsEnum.PROTOCOL.getAttribute(integrationParams).ifPresent(protocol -> resultParams.put(EmailSettingsEnum.PROTOCOL.getAttribute(), protocol));
        Optional.ofNullable(integrationParams.get(EmailSettingsEnum.AUTH_ENABLED.getAttribute())).ifPresent(authEnabledAttribute -> {
            boolean isAuthEnabled = BooleanUtils.toBoolean((String)String.valueOf(authEnabledAttribute));
            if (isAuthEnabled) {
                EmailSettingsEnum.USERNAME.getAttribute(integrationParams).ifPresent(username -> resultParams.put(EmailSettingsEnum.USERNAME.getAttribute(), username));
                EmailSettingsEnum.PASSWORD.getAttribute(integrationParams).ifPresent(password -> resultParams.put(EmailSettingsEnum.PASSWORD.getAttribute(), this.basicTextEncryptor.encrypt(password)));
            } else {
                resultParams.put(EmailSettingsEnum.USERNAME.getAttribute(), null);
                resultParams.put(EmailSettingsEnum.PASSWORD.getAttribute(), null);
            }
            resultParams.put(EmailSettingsEnum.AUTH_ENABLED.getAttribute(), isAuthEnabled);
        });
        EmailSettingsEnum.STAR_TLS_ENABLED.getAttribute(integrationParams).ifPresent(attr -> resultParams.put(EmailSettingsEnum.STAR_TLS_ENABLED.getAttribute(), BooleanUtils.toBoolean((String)attr)));
        EmailSettingsEnum.SSL_ENABLED.getAttribute(integrationParams).ifPresent(attr -> resultParams.put(EmailSettingsEnum.SSL_ENABLED.getAttribute(), BooleanUtils.toBoolean((String)attr)));
        EmailSettingsEnum.HOST.getAttribute(integrationParams).ifPresent(attr -> resultParams.put(EmailSettingsEnum.HOST.getAttribute(), attr));
        return resultParams;
    }

    @Override
    public boolean checkConnection(Integration integration) {
        Optional<EmailService> emailService = this.emailServiceFactory.getEmailService(integration);
        if (emailService.isPresent()) {
            try {
                emailService.get().testConnection();
            }
            catch (MessagingException ex) {
                LOGGER.error("Cannot send email to user", (Throwable)ex);
                BusinessRule.fail().withError(ErrorType.FORBIDDEN_OPERATION, new Object[]{"Email configuration is incorrect. Please, check your configuration. " + ex.getMessage()});
            }
            if (integration.getId() == null) {
                try {
                    EmailSettingsEnum.AUTH_ENABLED.getAttribute(integration.getParams().getParams()).ifPresent(authEnabled -> {
                        if (BooleanUtils.toBoolean((String)authEnabled)) {
                            String sendTo = (String)EmailSettingsEnum.USERNAME.getAttribute(integration.getParams().getParams()).orElseThrow(() -> new ReportPortalException(ErrorType.EMAIL_CONFIGURATION_IS_INCORRECT, new Object[]{"Email server username is not specified."}));
                            ((EmailService)((Object)((Object)emailService.get()))).sendConnectionTestEmail(sendTo);
                        }
                    });
                }
                catch (Exception ex) {
                    BusinessRule.fail().withError(ErrorType.EMAIL_CONFIGURATION_IS_INCORRECT, new Object[]{Suppliers.formattedSupplier((String)("Unable to send connection test email. " + ex.getMessage()), (Supplier[])new Supplier[0])});
                }
            }
        } else {
            return false;
        }
        return true;
    }
}

