/*
 * Decompiled with CFR 0.152.
 */
package com.epam.ta.reportportal.core.integration.util;

import com.epam.reportportal.extension.PluginCommand;
import com.epam.reportportal.extension.ReportPortalExtensionPoint;
import com.epam.ta.reportportal.commons.validation.BusinessRule;
import com.epam.ta.reportportal.core.integration.util.IntegrationService;
import com.epam.ta.reportportal.core.plugin.PluginBox;
import com.epam.ta.reportportal.dao.IntegrationRepository;
import com.epam.ta.reportportal.entity.integration.Integration;
import com.epam.ta.reportportal.entity.integration.IntegrationParams;
import com.epam.ta.reportportal.entity.integration.IntegrationType;
import com.epam.ta.reportportal.entity.project.Project;
import com.epam.ta.reportportal.exception.ReportPortalException;
import com.epam.ta.reportportal.ws.model.ErrorType;
import com.epam.ta.reportportal.ws.model.integration.IntegrationRQ;
import java.time.LocalDateTime;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class BasicIntegrationServiceImpl
implements IntegrationService {
    private static final String TEST_CONNECTION_COMMAND = "testConnection";
    protected IntegrationRepository integrationRepository;
    protected PluginBox pluginBox;

    @Autowired
    public BasicIntegrationServiceImpl(IntegrationRepository integrationRepository, PluginBox pluginBox) {
        this.integrationRepository = integrationRepository;
        this.pluginBox = pluginBox;
    }

    @Override
    public Map<String, Object> retrieveIntegrationParams(Map<String, Object> integrationParams) {
        return integrationParams;
    }

    private static IntegrationParams getIntegrationParams(Integration integration, Map<String, Object> retrievedParams) {
        if (integration.getParams() != null && integration.getParams().getParams() != null) {
            integration.getParams().getParams().putAll(retrievedParams);
            return integration.getParams();
        }
        return new IntegrationParams(retrievedParams);
    }

    @Override
    public Integration createIntegration(IntegrationRQ integrationRq, IntegrationType integrationType) {
        Integration integration = new Integration();
        integration.setCreationDate(LocalDateTime.now());
        Map<String, Object> integrationParams = this.retrieveIntegrationParams(integrationRq.getIntegrationParams());
        integration.setParams(new IntegrationParams(integrationParams));
        integration.setType(integrationType);
        integration.setEnabled(integrationRq.getEnabled().booleanValue());
        integration.setName(integrationRq.getName());
        return integration;
    }

    @Override
    public Integration updateIntegration(Integration integration, IntegrationRQ integrationRQ) {
        Map<String, Object> integrationParams = this.retrieveIntegrationParams(integrationRQ.getIntegrationParams());
        IntegrationParams params = BasicIntegrationServiceImpl.getIntegrationParams(integration, integrationParams);
        integration.setParams(params);
        Optional.ofNullable(integrationRQ.getEnabled()).ifPresent(arg_0 -> ((Integration)integration).setEnabled(arg_0));
        Optional.ofNullable(integrationRQ.getName()).ifPresent(arg_0 -> ((Integration)integration).setName(arg_0));
        return integration;
    }

    @Override
    public boolean validateIntegration(Integration integration) {
        List global = this.integrationRepository.findAllGlobalByType(integration.getType());
        BusinessRule.expect((Object)global, List::isEmpty).verify(ErrorType.UNABLE_INTERACT_WITH_INTEGRATION, new Object[]{"Integration with type " + integration.getType().getName() + " is already exists"});
        return true;
    }

    @Override
    public boolean validateIntegration(Integration integration, Project project) {
        List integrations = this.integrationRepository.findAllByProjectIdAndType(project.getId(), integration.getType());
        BusinessRule.expect((Object)integrations, List::isEmpty).verify(ErrorType.UNABLE_INTERACT_WITH_INTEGRATION, new Object[]{"Integration with type " + integration.getType().getName() + " is already exists for project " + project.getName()});
        return true;
    }

    @Override
    public boolean checkConnection(Integration integration) {
        ReportPortalExtensionPoint pluginInstance = this.pluginBox.getInstance(integration.getType().getName(), ReportPortalExtensionPoint.class).orElseThrow(() -> new ReportPortalException(ErrorType.BAD_REQUEST_ERROR, new Object[]{"Plugin for {} isn't installed", integration.getType().getName()}));
        PluginCommand commandToExecute = Optional.ofNullable(pluginInstance.getCommandToExecute(TEST_CONNECTION_COMMAND)).orElseThrow(() -> new ReportPortalException(ErrorType.BAD_REQUEST_ERROR, new Object[]{"Command {} is not found in plugin {}.", TEST_CONNECTION_COMMAND, integration.getType().getName()}));
        return (Boolean)commandToExecute.executeCommand(integration, integration.getParams().getParams());
    }
}

