/*
 * Decompiled with CFR 0.152.
 */
package com.epam.ta.reportportal.core.integration.plugin.impl;

import com.epam.reportportal.extension.common.ExtensionPoint;
import com.epam.ta.reportportal.commons.validation.BusinessRule;
import com.epam.ta.reportportal.commons.validation.Suppliers;
import com.epam.ta.reportportal.core.integration.plugin.PluginLoader;
import com.epam.ta.reportportal.core.integration.util.property.IntegrationDetailsProperties;
import com.epam.ta.reportportal.core.plugin.PluginInfo;
import com.epam.ta.reportportal.dao.IntegrationTypeRepository;
import com.epam.ta.reportportal.entity.integration.IntegrationType;
import com.epam.ta.reportportal.exception.ReportPortalException;
import com.epam.ta.reportportal.filesystem.DataStore;
import com.epam.ta.reportportal.ws.converter.builders.IntegrationTypeBuilder;
import com.epam.ta.reportportal.ws.model.ErrorType;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.FileAttribute;
import java.time.LocalDateTime;
import java.util.Objects;
import java.util.Optional;
import javax.validation.constraints.NotNull;
import org.pf4j.PluginDescriptor;
import org.pf4j.PluginDescriptorFinder;
import org.pf4j.PluginException;
import org.pf4j.PluginWrapper;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;

@Service
public class PluginLoaderImpl
implements PluginLoader {
    private final String pluginsRootPath;
    private final DataStore dataStore;
    private final IntegrationTypeRepository integrationTypeRepository;
    private final PluginDescriptorFinder pluginDescriptorFinder;

    @Autowired
    public PluginLoaderImpl(@Value(value="${rp.plugins.path}") String pluginsRootPath, DataStore dataStore, IntegrationTypeRepository integrationTypeRepository, PluginDescriptorFinder pluginDescriptorFinder) {
        this.pluginsRootPath = pluginsRootPath;
        this.dataStore = dataStore;
        this.integrationTypeRepository = integrationTypeRepository;
        this.pluginDescriptorFinder = pluginDescriptorFinder;
    }

    @Override
    @NotNull
    public PluginInfo extractPluginInfo(Path pluginPath) throws PluginException {
        PluginDescriptor pluginDescriptor = this.pluginDescriptorFinder.find(pluginPath);
        return new PluginInfo(pluginDescriptor.getPluginId(), pluginDescriptor.getVersion());
    }

    @Override
    public IntegrationType retrieveIntegrationType(PluginInfo pluginInfo) {
        IntegrationType integrationType = this.integrationTypeRepository.findByName(pluginInfo.getId()).map(it -> {
            IntegrationDetailsProperties.VERSION.getValue(it.getDetails().getDetails()).map(String::valueOf).ifPresent(version -> BusinessRule.expect((Object)version, v -> !v.equalsIgnoreCase(pluginInfo.getVersion())).verify(ErrorType.PLUGIN_UPLOAD_ERROR, new Object[]{Suppliers.formattedSupplier((String)"Plugin with ID = '{}' of the same VERSION = '{}' has already been uploaded.", (Object[])new Object[]{pluginInfo.getId(), pluginInfo.getVersion()})}));
            return it;
        }).orElseGet(() -> new IntegrationTypeBuilder().get());
        if (integrationType.getDetails() == null) {
            integrationType.setDetails(IntegrationTypeBuilder.createIntegrationTypeDetails());
        }
        integrationType.setIntegrationGroup(integrationType.getIntegrationGroup());
        integrationType.setCreationDate(LocalDateTime.now());
        IntegrationDetailsProperties.VERSION.setValue(integrationType.getDetails(), pluginInfo.getVersion());
        return integrationType;
    }

    @Override
    public boolean validatePluginExtensionClasses(PluginWrapper plugin) {
        return plugin.getPluginManager().getExtensionClasses(plugin.getPluginId()).stream().map(ExtensionPoint::findByExtension).anyMatch(Optional::isPresent);
    }

    @Override
    public String saveToDataStore(String fileName, InputStream fileStream) throws ReportPortalException {
        return this.dataStore.save(fileName, fileStream);
    }

    @Override
    public String savePlugin(String fileName, InputStream fileStream) throws ReportPortalException {
        return this.dataStore.save(fileName, fileStream);
    }

    @Override
    public void savePlugin(Path pluginPath, InputStream fileStream) throws IOException {
        Files.copy(fileStream, pluginPath, StandardCopyOption.REPLACE_EXISTING);
    }

    @Override
    public void copyFromDataStore(String fileId, Path pluginPath) throws IOException {
        if (Objects.nonNull(pluginPath.getParent())) {
            Files.createDirectories(pluginPath.getParent(), new FileAttribute[0]);
        }
        Files.copy(this.dataStore.load(fileId), pluginPath, new CopyOption[0]);
    }

    @Override
    public void deleteFromDataStore(String fileId) {
        this.dataStore.delete(fileId);
    }

    @Override
    public void deletePreviousPlugin(PluginWrapper previousPlugin, String newPluginFileName) throws IOException {
        if (!previousPlugin.getPluginPath().equals(Paths.get(this.pluginsRootPath, newPluginFileName))) {
            Files.deleteIfExists(previousPlugin.getPluginPath());
        }
    }

    @Override
    public void deleteTempPlugin(String pluginFileDirectory, String pluginFileName) throws IOException {
        Files.deleteIfExists(Paths.get(pluginFileDirectory, pluginFileName));
    }
}

