/*
 * Decompiled with CFR 0.152.
 */
package com.epam.ta.reportportal.core.integration.impl;

import com.epam.reportportal.extension.PluginCommand;
import com.epam.reportportal.extension.ReportPortalExtensionPoint;
import com.epam.ta.reportportal.commons.ReportPortalUser;
import com.epam.ta.reportportal.commons.validation.BusinessRule;
import com.epam.ta.reportportal.core.integration.ExecuteIntegrationHandler;
import com.epam.ta.reportportal.core.plugin.PluginBox;
import com.epam.ta.reportportal.dao.IntegrationRepository;
import com.epam.ta.reportportal.entity.integration.Integration;
import com.epam.ta.reportportal.exception.ReportPortalException;
import com.epam.ta.reportportal.ws.model.ErrorType;
import java.util.Map;
import java.util.Optional;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class ExecuteIntegrationHandlerImpl
implements ExecuteIntegrationHandler {
    private final IntegrationRepository integrationRepository;
    private final PluginBox pluginBox;

    @Autowired
    public ExecuteIntegrationHandlerImpl(IntegrationRepository integrationRepository, PluginBox pluginBox) {
        this.integrationRepository = integrationRepository;
        this.pluginBox = pluginBox;
    }

    @Override
    public Object executeCommand(ReportPortalUser.ProjectDetails projectDetails, Long integrationId, String command, Map<String, ?> executionParams) {
        Optional optionalIntegration = this.integrationRepository.findByIdAndProjectId(integrationId, projectDetails.getProjectId());
        if (!optionalIntegration.isPresent()) {
            optionalIntegration = this.integrationRepository.findGlobalById(integrationId);
        }
        BusinessRule.expect((Object)optionalIntegration, Optional::isPresent).verify(ErrorType.INTEGRATION_NOT_FOUND, new Object[]{integrationId});
        Integration integration = (Integration)optionalIntegration.get();
        ReportPortalExtensionPoint pluginInstance = this.pluginBox.getInstance(integration.getType().getName(), ReportPortalExtensionPoint.class).orElseThrow(() -> new ReportPortalException(ErrorType.BAD_REQUEST_ERROR, new Object[]{"Plugin for {} isn't installed", integration.getType().getName()}));
        PluginCommand commandToExecute = Optional.ofNullable(pluginInstance.getCommandToExecute(command)).orElseThrow(() -> new ReportPortalException(ErrorType.BAD_REQUEST_ERROR, new Object[]{"Command {} is not found in plugin {}.", command, integration.getType().getName()}));
        return commandToExecute.executeCommand(integration, executionParams);
    }
}

