/*
 * Decompiled with CFR 0.152.
 */
package com.epam.ta.reportportal.core.imprt.impl;

import com.epam.ta.reportportal.core.imprt.impl.ImportStrategy;
import com.epam.ta.reportportal.core.imprt.impl.ImportStrategyFactory;
import com.epam.ta.reportportal.core.imprt.impl.ImportType;
import com.google.common.collect.ImmutableMap;
import java.util.Map;
import org.apache.commons.io.FilenameUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Configuration;
import org.springframework.stereotype.Service;

@Service
@Configuration
public class ImportStrategyFactoryImpl
implements ImportStrategyFactory {
    private final Map<ImportType, Map<String, ImportStrategy>> MAPPING;

    @Autowired
    public ImportStrategyFactoryImpl(ImportStrategy zipImportStrategy, ImportStrategy xmlImportStrategy) {
        ImmutableMap xunitStrategyMap = ImmutableMap.builder().put((Object)"zip", (Object)zipImportStrategy).put((Object)"xml", (Object)xmlImportStrategy).build();
        this.MAPPING = ImmutableMap.builder().put((Object)ImportType.XUNIT, (Object)xunitStrategyMap).build();
    }

    @Override
    public ImportStrategy getImportStrategy(ImportType type, String filename) {
        return this.MAPPING.get((Object)type).get(FilenameUtils.getExtension((String)filename));
    }
}

