/*
 * Decompiled with CFR 0.152.
 */
package com.epam.ta.reportportal.core.imprt.impl;

import com.epam.ta.reportportal.commons.ReportPortalUser;
import com.epam.ta.reportportal.core.imprt.impl.ImportStrategy;
import com.epam.ta.reportportal.core.imprt.impl.ParseResults;
import com.epam.ta.reportportal.core.launch.FinishLaunchHandler;
import com.epam.ta.reportportal.core.launch.StartLaunchHandler;
import com.epam.ta.reportportal.dao.LaunchRepository;
import com.epam.ta.reportportal.entity.enums.StatusEnum;
import com.epam.ta.reportportal.entity.launch.Launch;
import com.epam.ta.reportportal.exception.ReportPortalException;
import com.epam.ta.reportportal.ws.model.ErrorType;
import com.epam.ta.reportportal.ws.model.FinishExecutionRQ;
import com.epam.ta.reportportal.ws.model.launch.Mode;
import com.epam.ta.reportportal.ws.model.launch.StartLaunchRQ;
import java.time.LocalDateTime;
import java.util.Arrays;
import java.util.Date;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public abstract class AbstractImportStrategy
implements ImportStrategy {
    protected static final Logger LOGGER = LoggerFactory.getLogger(AbstractImportStrategy.class);
    private static final Date initialStartTime = new Date(0L);
    protected static final ExecutorService service = Executors.newFixedThreadPool(5);
    private StartLaunchHandler startLaunchHandler;
    private FinishLaunchHandler finishLaunchHandler;
    private LaunchRepository launchRepository;

    @Autowired
    public void setStartLaunchHandler(StartLaunchHandler startLaunchHandler) {
        this.startLaunchHandler = startLaunchHandler;
    }

    @Autowired
    public void setFinishLaunchHandler(FinishLaunchHandler finishLaunchHandler) {
        this.finishLaunchHandler = finishLaunchHandler;
    }

    @Autowired
    public void setLaunchRepository(LaunchRepository launchRepository) {
        this.launchRepository = launchRepository;
    }

    protected ParseResults processResults(CompletableFuture ... futures) {
        ParseResults results = new ParseResults();
        Arrays.stream(futures).map(it -> (ParseResults)it.join()).forEach(res -> {
            results.checkAndSetStartLaunchTime(res.getStartTime());
            results.increaseDuration(res.getDuration());
        });
        return results;
    }

    protected String startLaunch(ReportPortalUser.ProjectDetails projectDetails, ReportPortalUser user, String launchName) {
        StartLaunchRQ startLaunchRQ = new StartLaunchRQ();
        startLaunchRQ.setStartTime(initialStartTime);
        startLaunchRQ.setName(launchName);
        startLaunchRQ.setMode(Mode.DEFAULT);
        return this.startLaunchHandler.startLaunch(user, projectDetails, startLaunchRQ).getId();
    }

    protected void finishLaunch(String launchId, ReportPortalUser.ProjectDetails projectDetails, ReportPortalUser user, ParseResults results, String baseUrl) {
        FinishExecutionRQ finishExecutionRQ = new FinishExecutionRQ();
        finishExecutionRQ.setEndTime(results.getEndTime());
        this.finishLaunchHandler.finishLaunch(launchId, finishExecutionRQ, projectDetails, user, baseUrl);
        Launch launch = (Launch)this.launchRepository.findByUuid(launchId).orElseThrow(() -> new ReportPortalException(ErrorType.LAUNCH_NOT_FOUND, new Object[]{launchId}));
        launch.setStartTime(results.getStartTime());
        this.launchRepository.save((Object)launch);
    }

    protected String cleanMessage(Exception e) {
        if (e.getCause() != null) {
            return e.getCause().getMessage();
        }
        return e.getMessage();
    }

    protected void updateBrokenLaunch(String savedLaunchId) {
        if (savedLaunchId != null) {
            Launch launch = (Launch)this.launchRepository.findByUuid(savedLaunchId).orElseThrow(() -> new ReportPortalException(ErrorType.LAUNCH_NOT_FOUND, new Object[0]));
            launch.setStartTime(LocalDateTime.now());
            launch.setStatus(StatusEnum.INTERRUPTED);
            this.launchRepository.save((Object)launch);
        }
    }
}

