/*
 * Decompiled with CFR 0.152.
 */
package com.epam.ta.reportportal.core.file.impl;

import com.epam.ta.reportportal.binary.AttachmentBinaryDataService;
import com.epam.ta.reportportal.binary.UserBinaryDataService;
import com.epam.ta.reportportal.commons.ReportPortalUser;
import com.epam.ta.reportportal.commons.validation.BusinessRule;
import com.epam.ta.reportportal.commons.validation.Suppliers;
import com.epam.ta.reportportal.core.file.GetFileHandler;
import com.epam.ta.reportportal.dao.UserRepository;
import com.epam.ta.reportportal.entity.attachment.BinaryData;
import com.epam.ta.reportportal.entity.project.ProjectUtils;
import com.epam.ta.reportportal.entity.user.User;
import com.epam.ta.reportportal.entity.user.UserRole;
import com.epam.ta.reportportal.exception.ReportPortalException;
import com.epam.ta.reportportal.util.ProjectExtractor;
import com.epam.ta.reportportal.ws.model.ErrorType;
import java.util.function.Predicate;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class GetFileHandlerImpl
implements GetFileHandler {
    private final UserRepository userRepository;
    private final UserBinaryDataService userDataStoreService;
    private final AttachmentBinaryDataService attachmentBinaryDataService;
    private final ProjectExtractor projectExtractor;

    @Autowired
    public GetFileHandlerImpl(UserRepository userRepository, UserBinaryDataService userDataStoreService, AttachmentBinaryDataService attachmentBinaryDataService, ProjectExtractor projectExtractor) {
        this.userRepository = userRepository;
        this.userDataStoreService = userDataStoreService;
        this.attachmentBinaryDataService = attachmentBinaryDataService;
        this.projectExtractor = projectExtractor;
    }

    @Override
    public BinaryData getUserPhoto(ReportPortalUser loggedInUser, boolean loadThumbnail) {
        User user = (User)this.userRepository.findByLogin(loggedInUser.getUsername()).orElseThrow(() -> new ReportPortalException(ErrorType.USER_NOT_FOUND, new Object[]{loggedInUser.getUsername()}));
        return this.userDataStoreService.loadUserPhoto(user, loadThumbnail);
    }

    @Override
    public BinaryData getUserPhoto(String username, ReportPortalUser loggedInUser, String projectName, boolean loadThumbnail) {
        User user = (User)this.userRepository.findByLogin(username).orElseThrow(() -> new ReportPortalException(ErrorType.USER_NOT_FOUND, new Object[]{username}));
        ReportPortalUser.ProjectDetails projectDetails = this.projectExtractor.extractProjectDetailsAdmin(loggedInUser, projectName);
        if (loggedInUser.getUserRole() != UserRole.ADMINISTRATOR) {
            BusinessRule.expect((Object)ProjectUtils.isAssignedToProject((User)user, (Long)projectDetails.getProjectId()), Predicate.isEqual(true)).verify(ErrorType.ACCESS_DENIED, new Object[]{Suppliers.formattedSupplier((String)"You are not assigned to project '{}'", (Object[])new Object[]{projectDetails.getProjectName()})});
        }
        return this.userDataStoreService.loadUserPhoto(user, loadThumbnail);
    }

    @Override
    public BinaryData loadFileById(Long fileId, ReportPortalUser.ProjectDetails projectDetails) {
        return this.attachmentBinaryDataService.load(fileId, projectDetails);
    }
}

