/*
 * Decompiled with CFR 0.152.
 */
package com.epam.ta.reportportal.core.events.handler;

import com.epam.ta.reportportal.core.analyzer.auto.LogIndexer;
import com.epam.ta.reportportal.core.analyzer.auto.impl.AnalyzerUtils;
import com.epam.ta.reportportal.core.events.item.ItemFinishedEvent;
import com.epam.ta.reportportal.dao.ProjectRepository;
import com.epam.ta.reportportal.entity.project.Project;
import com.epam.ta.reportportal.exception.ReportPortalException;
import com.epam.ta.reportportal.ws.model.ErrorType;
import com.epam.ta.reportportal.ws.model.project.AnalyzerConfig;
import com.google.common.collect.Lists;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.scheduling.annotation.Async;
import org.springframework.stereotype.Component;
import org.springframework.transaction.annotation.Propagation;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.transaction.event.TransactionalEventListener;

@Component
public class TestItemFinishedEventHandler {
    private final ProjectRepository projectRepository;
    private final LogIndexer logIndexer;

    @Autowired
    public TestItemFinishedEventHandler(ProjectRepository projectRepository, LogIndexer logIndexer) {
        this.projectRepository = projectRepository;
        this.logIndexer = logIndexer;
    }

    @Async
    @Transactional(propagation=Propagation.REQUIRES_NEW)
    @TransactionalEventListener
    public void onApplicationEvent(ItemFinishedEvent itemFinishedEvent) {
        Project project = (Project)this.projectRepository.findById((Object)itemFinishedEvent.getProjectId()).orElseThrow(() -> new ReportPortalException(ErrorType.PROJECT_NOT_FOUND, new Object[]{itemFinishedEvent.getProjectId()}));
        AnalyzerConfig analyzerConfig = AnalyzerUtils.getAnalyzerConfig(project);
        this.logIndexer.indexItemsLogs(itemFinishedEvent.getProjectId(), itemFinishedEvent.getLaunchId(), Lists.newArrayList((Object[])new Long[]{itemFinishedEvent.getItemId()}), analyzerConfig);
    }
}

