/*
 * Decompiled with CFR 0.152.
 */
package com.epam.ta.reportportal.core.events.activity;

import com.epam.ta.reportportal.core.events.ActivityEvent;
import com.epam.ta.reportportal.core.events.activity.AbstractEvent;
import com.epam.ta.reportportal.entity.activity.Activity;
import com.epam.ta.reportportal.entity.activity.ActivityAction;
import com.epam.ta.reportportal.ws.converter.builders.ActivityBuilder;
import com.epam.ta.reportportal.ws.model.activity.TestItemActivityResource;
import com.epam.ta.reportportal.ws.model.externalsystem.Ticket;
import com.google.common.base.Strings;

public class TicketPostedEvent
extends AbstractEvent
implements ActivityEvent {
    private Ticket ticket;
    private TestItemActivityResource testItemActivityResource;

    public TicketPostedEvent() {
    }

    public TicketPostedEvent(Ticket ticket, Long userId, String userLogin, TestItemActivityResource testItemActivityResource) {
        super(userId, userLogin);
        this.ticket = ticket;
        this.testItemActivityResource = testItemActivityResource;
    }

    public Ticket getTicket() {
        return this.ticket;
    }

    public void setTicket(Ticket ticket) {
        this.ticket = ticket;
    }

    public TestItemActivityResource getTestItemActivityResource() {
        return this.testItemActivityResource;
    }

    public void setTestItemActivityResource(TestItemActivityResource testItemActivityResource) {
        this.testItemActivityResource = testItemActivityResource;
    }

    @Override
    public Activity toActivity() {
        return new ActivityBuilder().addCreatedNow().addAction(ActivityAction.POST_ISSUE).addActivityEntityType(Activity.ActivityEntityType.TICKET).addUserId(this.getUserId()).addUserName(this.getUserLogin()).addObjectId(this.testItemActivityResource.getId()).addObjectName(this.testItemActivityResource.getName()).addProjectId(this.testItemActivityResource.getProjectId()).addHistoryField("ticketId", Strings.isNullOrEmpty((String)this.testItemActivityResource.getTickets()) ? "" : this.testItemActivityResource.getTickets(), Strings.isNullOrEmpty((String)this.testItemActivityResource.getTickets()) ? this.ticket.getId() + ":" + this.ticket.getTicketUrl() : this.testItemActivityResource.getTickets() + "," + this.ticket.getId() + ":" + this.ticket.getTicketUrl()).get();
    }
}

