/*
 * Decompiled with CFR 0.152.
 */
package com.epam.ta.reportportal.core.events;

import com.epam.ta.reportportal.core.events.ActivityEvent;
import com.epam.ta.reportportal.core.events.MessageBus;
import com.epam.ta.reportportal.core.events.attachment.DeleteAttachmentEvent;
import com.epam.ta.reportportal.entity.activity.Activity;
import org.springframework.amqp.core.AmqpTemplate;

public class MessageBusImpl
implements MessageBus {
    private final AmqpTemplate amqpTemplate;

    public MessageBusImpl(AmqpTemplate amqpTemplate) {
        this.amqpTemplate = amqpTemplate;
    }

    @Override
    public void publish(String exchange, String route, Object o) {
        this.amqpTemplate.convertAndSend(exchange, route, o);
    }

    @Override
    public void publish(String route, Object o) {
        this.amqpTemplate.convertSendAndReceive(route, o);
    }

    @Override
    public void broadcastEvent(Object o) {
        this.amqpTemplate.convertAndSend("broadcast.events", "", o);
    }

    @Override
    public void publishActivity(ActivityEvent event) {
        Activity activity = event.toActivity();
        if (activity != null) {
            String key = "activity." + activity.getProjectId() + "." + activity.getActivityEntityType() + "." + activity.getAction();
            this.amqpTemplate.convertAndSend("activity", key, (Object)activity);
        }
    }

    @Override
    public void publishDeleteAttachmentEvent(DeleteAttachmentEvent event) {
        this.amqpTemplate.convertAndSend("attachment", "attachment.delete", (Object)event);
    }
}

