/*
 * Decompiled with CFR 0.152.
 */
package com.epam.ta.reportportal.core.configs.rabbit;

import com.epam.ta.reportportal.core.configs.Conditions;
import com.epam.ta.reportportal.ws.rabbit.AsyncReportingListener;
import java.util.ArrayList;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.amqp.core.AmqpAdmin;
import org.springframework.amqp.core.Binding;
import org.springframework.amqp.core.BindingBuilder;
import org.springframework.amqp.core.Exchange;
import org.springframework.amqp.core.ExchangeBuilder;
import org.springframework.amqp.core.MessageListener;
import org.springframework.amqp.core.Queue;
import org.springframework.amqp.core.QueueBuilder;
import org.springframework.amqp.rabbit.connection.ConnectionFactory;
import org.springframework.amqp.rabbit.listener.AbstractMessageListenerContainer;
import org.springframework.amqp.rabbit.listener.SimpleMessageListenerContainer;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.beans.factory.config.ConfigurableListableBeanFactory;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationEventPublisher;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Conditional;
import org.springframework.context.annotation.Configuration;

@Configuration
@Conditional(value={Conditions.NotTestCondition.class})
public class ReportingConfiguration {
    private static final Logger logger = LoggerFactory.getLogger(ReportingConfiguration.class);
    public static final long DEAD_LETTER_DELAY_MILLIS = 60000L;
    public static final long DEAD_LETTER_MAX_RETRY = 10L;
    public static final String EXCHANGE_REPORTING = "reporting";
    public static final String EXCHANGE_REPORTING_RETRY = "reporting.retry";
    public static final String QUEUE_PREFIX = "reporting";
    public static final String QUEUE_RETRY_PREFIX = "reporting.retry";
    public static final String QUEUE_DLQ = "reporting.dlq";
    @Value(value="${rp.amqp.queues}")
    public int queueAmount;
    @Value(value="${rp.amqp.queuesPerPod:1000000}")
    private int queuesPerPod;
    @Autowired
    private ApplicationContext applicationContext;
    @Autowired
    private ConfigurableListableBeanFactory configurableBeanFactory;

    @Bean
    public Exchange reportingExchange(AmqpAdmin amqpAdmin) {
        Exchange exchange = ExchangeBuilder.directExchange((String)"reporting").durable(true).build();
        amqpAdmin.declareExchange(exchange);
        return exchange;
    }

    @Bean
    public Exchange reportingRetryExchange(AmqpAdmin amqpAdmin) {
        Exchange exchange = ExchangeBuilder.directExchange((String)"reporting.retry").durable(true).build();
        amqpAdmin.declareExchange(exchange);
        return exchange;
    }

    @Bean
    public List<Queue> queues(AmqpAdmin amqpAdmin) {
        ArrayList<Queue> queues = new ArrayList<Queue>();
        for (int i = 0; i < this.queueAmount; ++i) {
            String index = String.valueOf(i);
            String queueName = "reporting." + index;
            Queue queue = QueueBuilder.durable((String)queueName).withArgument("x-dead-letter-exchange", (Object)"reporting.retry").withArgument("x-dead-letter-routing-key", (Object)index).build();
            queue.setShouldDeclare(true);
            queue.setAdminsThatShouldDeclare(new Object[]{amqpAdmin});
            this.registerSingleton(queueName, queue);
            amqpAdmin.declareQueue(queue);
            queues.add(queue);
        }
        return queues;
    }

    @Bean
    public List<Queue> retryQueues(AmqpAdmin amqpAdmin) {
        ArrayList<Queue> queues = new ArrayList<Queue>();
        for (int i = 0; i < this.queueAmount; ++i) {
            String index = String.valueOf(i);
            String queueName = "reporting.retry." + index;
            Queue retryQueue = QueueBuilder.durable((String)queueName).withArgument("x-dead-letter-exchange", (Object)"reporting").withArgument("x-dead-letter-routing-key", (Object)index).withArgument("x-message-ttl", (Object)60000L).build();
            retryQueue.setShouldDeclare(true);
            retryQueue.setAdminsThatShouldDeclare(new Object[]{amqpAdmin});
            this.registerSingleton(queueName, retryQueue);
            amqpAdmin.declareQueue(retryQueue);
            queues.add(retryQueue);
        }
        return queues;
    }

    @Bean
    public Queue queueDlq(AmqpAdmin amqpAdmin) {
        Queue queue = QueueBuilder.durable((String)QUEUE_DLQ).build();
        queue.setShouldDeclare(true);
        queue.setAdminsThatShouldDeclare(new Object[]{amqpAdmin});
        amqpAdmin.declareQueue(queue);
        return queue;
    }

    @Bean
    public List<Binding> bindings(AmqpAdmin amqpAdmin, @Qualifier(value="reportingExchange") Exchange reportingExchange, @Qualifier(value="reportingRetryExchange") Exchange reportingRetryExchange, @Qualifier(value="queues") List<Queue> queues, @Qualifier(value="queueDlq") Queue queueDlq, @Qualifier(value="retryQueues") List<Queue> retryQueues) {
        Binding queueBinding;
        String index;
        ArrayList<Binding> bindings = new ArrayList<Binding>();
        int i = 0;
        for (Queue queue : queues) {
            index = String.valueOf(i);
            queueBinding = BindingBuilder.bind((Queue)queue).to(reportingExchange).with(index).noargs();
            bindings.add(queueBinding);
            queueBinding.setShouldDeclare(true);
            queueBinding.setAdminsThatShouldDeclare(new Object[]{amqpAdmin});
            amqpAdmin.declareBinding(queueBinding);
            this.registerSingleton("queueBinding." + queue.getName(), queueBinding);
            ++i;
        }
        i = 0;
        for (Queue retryQueue : retryQueues) {
            index = String.valueOf(i);
            queueBinding = BindingBuilder.bind((Queue)retryQueue).to(reportingRetryExchange).with(index).noargs();
            bindings.add(queueBinding);
            queueBinding.setShouldDeclare(true);
            queueBinding.setAdminsThatShouldDeclare(new Object[]{amqpAdmin});
            amqpAdmin.declareBinding(queueBinding);
            this.registerSingleton("queueBinding." + retryQueue.getName(), queueBinding);
            ++i;
        }
        Binding queueBinding2 = BindingBuilder.bind((Queue)queueDlq).to(reportingRetryExchange).with(QUEUE_DLQ).noargs();
        amqpAdmin.declareBinding(queueBinding2);
        return bindings;
    }

    @Bean
    @Qualifier(value="reportingListenerContainers")
    public List<AbstractMessageListenerContainer> listenerContainers(ConnectionFactory connectionFactory, ApplicationEventPublisher applicationEventPublisher, @Qualifier(value="queues") List<Queue> queues) {
        ArrayList<AbstractMessageListenerContainer> containers = new ArrayList<AbstractMessageListenerContainer>();
        int consumersCount = 0;
        while (consumersCount < this.queuesPerPod) {
            SimpleMessageListenerContainer listenerContainer = new SimpleMessageListenerContainer(connectionFactory);
            containers.add((AbstractMessageListenerContainer)listenerContainer);
            listenerContainer.setConnectionFactory(connectionFactory);
            listenerContainer.addQueueNames(new String[]{queues.get(consumersCount).getName()});
            listenerContainer.setExclusive(true);
            listenerContainer.setMissingQueuesFatal(false);
            listenerContainer.setApplicationEventPublisher(applicationEventPublisher);
            listenerContainer.setupMessageListener(this.reportingListener());
            listenerContainer.afterPropertiesSet();
            logger.info("Consumer is created, current consumers count is {}", (Object)(++consumersCount));
        }
        return containers;
    }

    @Bean
    public MessageListener reportingListener() {
        return new AsyncReportingListener();
    }

    private void registerSingleton(String name, Object bean) {
        this.configurableBeanFactory.registerSingleton(name.trim(), bean);
        this.applicationContext.getAutowireCapableBeanFactory().autowireBean(bean);
        this.applicationContext.getAutowireCapableBeanFactory().initializeBean(bean, name);
    }
}

