/*
 * Decompiled with CFR 0.152.
 */
package com.epam.ta.reportportal.core.configs;

import com.epam.ta.reportportal.core.item.impl.status.FromFailedStatusChangingStrategy;
import com.epam.ta.reportportal.core.item.impl.status.FromInterruptedStatusChangingStrategy;
import com.epam.ta.reportportal.core.item.impl.status.FromPassedStatusChangingStrategy;
import com.epam.ta.reportportal.core.item.impl.status.FromSkippedStatusChangingStrategy;
import com.epam.ta.reportportal.core.item.impl.status.StatusChangingStrategy;
import com.epam.ta.reportportal.entity.enums.StatusEnum;
import com.google.common.collect.ImmutableMap;
import java.util.Map;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

@Configuration
public class ItemStatusChangingStrategyConfig {
    private final FromFailedStatusChangingStrategy fromFailedStrategy;
    private final FromPassedStatusChangingStrategy fromPassedStrategy;
    private final FromInterruptedStatusChangingStrategy fromInterruptedStrategy;
    private final FromSkippedStatusChangingStrategy fromSkippedStrategy;

    @Autowired
    public ItemStatusChangingStrategyConfig(FromFailedStatusChangingStrategy fromFailedStrategy, FromPassedStatusChangingStrategy fromPassedStrategy, FromInterruptedStatusChangingStrategy fromInterruptedStrategy, FromSkippedStatusChangingStrategy fromSkippedStrategy) {
        this.fromFailedStrategy = fromFailedStrategy;
        this.fromPassedStrategy = fromPassedStrategy;
        this.fromInterruptedStrategy = fromInterruptedStrategy;
        this.fromSkippedStrategy = fromSkippedStrategy;
    }

    @Bean
    public Map<StatusEnum, StatusChangingStrategy> statusChangingStrategyMapping() {
        return ImmutableMap.builder().put((Object)StatusEnum.PASSED, (Object)this.fromPassedStrategy).put((Object)StatusEnum.FAILED, (Object)this.fromFailedStrategy).put((Object)StatusEnum.SKIPPED, (Object)this.fromSkippedStrategy).put((Object)StatusEnum.INTERRUPTED, (Object)this.fromInterruptedStrategy).build();
    }
}

