/*
 * Decompiled with CFR 0.152.
 */
package com.epam.ta.reportportal.core.analyzer.strategy;

import com.epam.ta.reportportal.commons.ReportPortalUser;
import com.epam.ta.reportportal.commons.validation.BusinessRule;
import com.epam.ta.reportportal.core.analyzer.auto.strategy.analyze.AnalyzeItemsMode;
import com.epam.ta.reportportal.core.analyzer.pattern.PatternAnalyzer;
import com.epam.ta.reportportal.core.analyzer.strategy.AbstractLaunchAnalysisStrategy;
import com.epam.ta.reportportal.dao.LaunchRepository;
import com.epam.ta.reportportal.dao.ProjectRepository;
import com.epam.ta.reportportal.entity.launch.Launch;
import com.epam.ta.reportportal.exception.ReportPortalException;
import com.epam.ta.reportportal.ws.model.ErrorType;
import com.epam.ta.reportportal.ws.model.launch.AnalyzeLaunchRQ;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.commons.collections.CollectionUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class LaunchPatternAnalysisStrategy
extends AbstractLaunchAnalysisStrategy {
    private final PatternAnalyzer patternAnalyzer;

    @Autowired
    public LaunchPatternAnalysisStrategy(ProjectRepository projectRepository, LaunchRepository launchRepository, PatternAnalyzer patternAnalyzer) {
        super(projectRepository, launchRepository);
        this.patternAnalyzer = patternAnalyzer;
    }

    @Override
    public void analyze(AnalyzeLaunchRQ analyzeRQ, ReportPortalUser.ProjectDetails projectDetails, ReportPortalUser user) {
        Set<AnalyzeItemsMode> analyzeItemsModes = analyzeRQ.getAnalyzeItemsModes().stream().map(AnalyzeItemsMode::fromString).collect(Collectors.toSet());
        BusinessRule.expect(analyzeItemsModes, CollectionUtils::isNotEmpty).verify(ErrorType.PATTERN_ANALYSIS_ERROR, new Object[]{"No analyze item mode specified."});
        Launch launch = (Launch)this.launchRepository.findById((Object)analyzeRQ.getLaunchId()).orElseThrow(() -> new ReportPortalException(ErrorType.LAUNCH_NOT_FOUND, new Object[]{analyzeRQ.getLaunchId()}));
        this.validateLaunch(launch, projectDetails);
        this.patternAnalyzer.analyzeTestItems(launch, analyzeItemsModes);
    }
}

