/*
 * Decompiled with CFR 0.152.
 */
package com.epam.ta.reportportal.core.analyzer.auto.impl;

import com.epam.ta.reportportal.core.analyzer.auto.impl.AnalyzerUtils;
import com.epam.ta.reportportal.dao.LogRepository;
import com.epam.ta.reportportal.entity.enums.LogLevel;
import com.epam.ta.reportportal.entity.item.TestItem;
import com.epam.ta.reportportal.entity.launch.Launch;
import com.epam.ta.reportportal.util.Predicates;
import com.epam.ta.reportportal.ws.model.analyzer.IndexLaunch;
import com.epam.ta.reportportal.ws.model.analyzer.IndexTestItem;
import com.epam.ta.reportportal.ws.model.project.AnalyzerConfig;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import org.apache.commons.collections.CollectionUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class LaunchPreparerService {
    private final LogRepository logRepository;

    @Autowired
    public LaunchPreparerService(LogRepository logRepository) {
        this.logRepository = logRepository;
    }

    public Optional<IndexLaunch> prepare(Launch launch, List<TestItem> testItems, AnalyzerConfig analyzerConfig) {
        List<IndexTestItem> rqTestItems;
        if (Predicates.LAUNCH_CAN_BE_INDEXED.test(launch) && !CollectionUtils.isEmpty(rqTestItems = this.prepareItemsForIndexing(testItems))) {
            return Optional.of(this.createIndexLaunch(launch.getProjectId(), launch.getId(), launch.getName(), analyzerConfig, rqTestItems));
        }
        return Optional.empty();
    }

    private IndexLaunch createIndexLaunch(Long projectId, Long launchId, String name, AnalyzerConfig analyzerConfig, List<IndexTestItem> rqTestItems) {
        IndexLaunch rqLaunch = new IndexLaunch();
        rqLaunch.setLaunchId(launchId);
        rqLaunch.setLaunchName(name);
        rqLaunch.setProjectId(projectId);
        rqLaunch.setAnalyzerConfig(analyzerConfig);
        rqLaunch.setTestItems(rqTestItems);
        return rqLaunch;
    }

    private List<IndexTestItem> prepareItemsForIndexing(List<TestItem> testItems) {
        return testItems.stream().filter(Predicates.ITEM_CAN_BE_INDEXED).map(it -> AnalyzerUtils.fromTestItem(it, this.logRepository.findAllByTestItemItemIdInAndLogLevelIsGreaterThanEqual(Collections.singletonList(it.getItemId()), Integer.valueOf(LogLevel.ERROR.toInt())))).filter(it -> !CollectionUtils.isEmpty((Collection)it.getLogs())).collect(Collectors.toList());
    }
}

