/*
 * Decompiled with CFR 0.152.
 */
package com.epam.ta.reportportal.auth.permissions;

import com.epam.ta.reportportal.auth.permissions.LookupPermission;
import com.epam.ta.reportportal.auth.permissions.Permission;
import com.epam.ta.reportportal.auth.permissions.ReportPortalPermissionEvaluator;
import com.epam.ta.reportportal.util.ApplicationContextAwareFactoryBean;
import java.util.HashMap;
import java.util.Map;
import org.springframework.security.access.PermissionEvaluator;

public class PermissionEvaluatorFactoryBean
extends ApplicationContextAwareFactoryBean<PermissionEvaluator> {
    public Class<?> getObjectType() {
        return PermissionEvaluator.class;
    }

    @Override
    protected PermissionEvaluator createInstance() {
        Map permissionBeans = this.getApplicationContext().getBeansWithAnnotation(LookupPermission.class);
        HashMap<String, Permission> permissionsMap = new HashMap<String, Permission>();
        for (Map.Entry permission : permissionBeans.entrySet()) {
            for (String permissionName : permission.getValue().getClass().getAnnotation(LookupPermission.class).value()) {
                if (!Permission.class.isAssignableFrom(permission.getValue().getClass())) continue;
                permissionsMap.put(permissionName, (Permission)permission.getValue());
            }
        }
        return new ReportPortalPermissionEvaluator(permissionsMap);
    }
}

