/*
 * Decompiled with CFR 0.152.
 */
package com.epam.ta.reportportal.ws.converter.converters;

import com.epam.ta.reportportal.database.entity.Project;
import com.epam.ta.reportportal.database.entity.item.issue.TestItemIssueType;
import com.epam.ta.reportportal.ws.converter.converters.ProjectConverter;
import com.epam.ta.reportportal.ws.model.project.config.ProjectSettingsResource;
import com.google.common.base.Preconditions;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;

public final class ProjectSettingsConverter {
    public static final Function<Project, ProjectSettingsResource> TO_RESOURCE = project -> {
        Preconditions.checkNotNull((Object)project);
        ProjectSettingsResource resource = new ProjectSettingsResource();
        resource.setProjectId(project.getId());
        Map<String, List> result = project.getConfiguration().getSubTypes().entrySet().stream().collect(Collectors.toMap(entry -> ((TestItemIssueType)entry.getKey()).getValue(), entry -> ((List)entry.getValue()).stream().map(ProjectConverter.TO_SUBTYPE_RESOURCE).collect(Collectors.toList())));
        resource.setSubTypes(result);
        resource.setStatisticsStrategy(project.getConfiguration().getStatisticsCalculationStrategy().name());
        return resource;
    };

    private ProjectSettingsConverter() {
    }
}

