/*
 * Decompiled with CFR 0.152.
 */
package com.epam.ta.reportportal.ws.converter.converters;

import com.epam.ta.reportportal.database.entity.Dashboard;
import com.epam.ta.reportportal.ws.model.dashboard.DashboardResource;
import com.google.common.base.Preconditions;
import java.util.Collections;
import java.util.Optional;
import java.util.function.Function;
import java.util.stream.Collectors;

public final class DashboardConverter {
    public static final Function<Dashboard, DashboardResource> TO_RESOURCE = dashboard -> {
        Preconditions.checkNotNull((Object)dashboard);
        DashboardResource resource = new DashboardResource();
        resource.setDashboardId(dashboard.getId());
        resource.setName(dashboard.getName());
        resource.setDescription(dashboard.getDescription());
        resource.setWidgets(Optional.ofNullable(dashboard.getWidgets()).orElseGet(Collections::emptyList).stream().map(TO_WIDGET_RESOURCE).collect(Collectors.toList()));
        Optional.ofNullable(dashboard.getAcl()).ifPresent(acl -> {
            resource.setOwner(acl.getOwnerUserId());
            resource.setShare(!acl.getEntries().isEmpty());
        });
        return resource;
    };
    private static final Function<Dashboard.WidgetObject, DashboardResource.WidgetObjectModel> TO_WIDGET_RESOURCE = widgetObject -> {
        DashboardResource.WidgetObjectModel resource = new DashboardResource.WidgetObjectModel();
        resource.setWidgetId(widgetObject.getWidgetId());
        resource.setWidgetPosition(widgetObject.getWidgetPosition());
        resource.setWidgetSize(widgetObject.getWidgetSize());
        return resource;
    };

    private DashboardConverter() {
    }
}

