/*
 * Decompiled with CFR 0.152.
 */
package com.epam.ta.reportportal.ws.converter;

import com.epam.ta.reportportal.database.entity.Project;
import com.epam.ta.reportportal.database.entity.project.ProjectUtils;
import com.epam.ta.reportportal.database.entity.user.User;
import com.epam.ta.reportportal.ws.converter.PagedResourcesAssembler;
import com.epam.ta.reportportal.ws.converter.builders.UserResourceBuilder;
import com.epam.ta.reportportal.ws.model.user.UserResource;
import java.util.HashMap;
import java.util.Optional;
import javax.inject.Provider;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Page;
import org.springframework.stereotype.Service;

@Service
public class UserResourceAssembler
extends PagedResourcesAssembler<User, UserResource> {
    @Autowired
    private Provider<UserResourceBuilder> builder;

    public UserResource toResource(User user) {
        return (UserResource)((UserResourceBuilder)this.builder.get()).addUser(user).build();
    }

    public com.epam.ta.reportportal.ws.model.Page<UserResource> toPagedResources(Page<User> content, Project project) {
        String entryType = project.getConfiguration().getEntryType().name();
        com.epam.ta.reportportal.ws.model.Page userResources = this.toPagedResources(content);
        for (UserResource userResource : userResources) {
            HashMap<String, UserResource.AssignedProject> assignedProjects = new HashMap<String, UserResource.AssignedProject>();
            UserResource.AssignedProject assignedProject = new UserResource.AssignedProject();
            Project.UserConfig userConfig = ProjectUtils.findUserConfigByLogin((Project)project, (String)userResource.getUserId());
            Optional.ofNullable(userConfig.getProjectRole()).ifPresent(it -> assignedProject.setProjectRole(it.name()));
            Optional.ofNullable(userConfig.getProposedRole()).ifPresent(it -> assignedProject.setProposedRole(it.name()));
            assignedProject.setEntryType(entryType);
            assignedProjects.put(project.getId(), assignedProject);
            userResource.setAssignedProjects(assignedProjects);
        }
        return userResources;
    }
}

