/*
 * Decompiled with CFR 0.152.
 */
package com.epam.ta.reportportal.ws.controller.impl;

import com.epam.ta.reportportal.commons.EntityUtils;
import com.epam.ta.reportportal.core.admin.ServerAdminHandler;
import com.epam.ta.reportportal.ws.controller.ISettingsController;
import com.epam.ta.reportportal.ws.model.OperationCompletionRS;
import com.epam.ta.reportportal.ws.model.settings.AnalyticsResource;
import com.epam.ta.reportportal.ws.model.settings.ServerEmailResource;
import com.epam.ta.reportportal.ws.model.settings.ServerSettingsResource;
import io.swagger.annotations.ApiOperation;
import java.security.Principal;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpStatus;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.stereotype.Controller;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.ResponseStatus;

@Controller
@RequestMapping(value={"/settings"})
@PreAuthorize(value="hasRole('ADMINISTRATOR')")
public class SettingsController
implements ISettingsController {
    @Autowired
    private ServerAdminHandler serverHandler;

    @RequestMapping(value={"/{profileId}"}, method={RequestMethod.GET})
    @ResponseBody
    @ResponseStatus(value=HttpStatus.OK)
    @ApiOperation(value="Get server email settings for specified profile", notes="'default' profile is using till additional UI implementations")
    public ServerSettingsResource getServerSettings(@PathVariable String profileId, Principal principal) {
        return this.serverHandler.getServerSettings(EntityUtils.normalizeId((String)profileId));
    }

    @RequestMapping(value={"/{profileId}/email"}, method={RequestMethod.POST, RequestMethod.PUT})
    @ResponseBody
    @ResponseStatus(value=HttpStatus.OK)
    @ApiOperation(value="Set server email settings for specified profile", notes="'default' profile is using till additional UI implementations")
    public OperationCompletionRS saveEmailSettings(@PathVariable String profileId, @RequestBody @Validated ServerEmailResource request, Principal principal) {
        return this.serverHandler.saveEmailSettings(EntityUtils.normalizeId((String)profileId), request);
    }

    @RequestMapping(value={"/{profileId}/email"}, method={RequestMethod.DELETE})
    @ResponseBody
    @ResponseStatus(value=HttpStatus.OK)
    @ApiOperation(value="Deletes email settings for specified profile", notes="'default' profile is using till additional UI implementations")
    public OperationCompletionRS deleteEmailSettings(@PathVariable String profileId) {
        return this.serverHandler.deleteEmailSettings(profileId);
    }

    @RequestMapping(value={"/{profileId}/analytics"}, method={RequestMethod.PUT, RequestMethod.POST})
    @ResponseBody
    @ResponseStatus(value=HttpStatus.OK)
    @ApiOperation(value="Updates analytics settings for specified profile")
    public OperationCompletionRS saveAnalyticsSettings(@PathVariable String profileId, @RequestBody @Validated AnalyticsResource request) {
        return this.serverHandler.saveAnalyticsSettings(EntityUtils.normalizeId((String)profileId), request);
    }
}

