/*
 * Decompiled with CFR 0.152.
 */
package com.epam.ta.reportportal.util;

import com.epam.ta.reportportal.database.entity.Launch;
import com.epam.ta.reportportal.database.entity.item.TestItem;
import com.epam.ta.reportportal.database.entity.item.issue.TestItemIssueType;
import com.epam.ta.reportportal.ws.model.launch.Mode;
import com.google.common.base.CharMatcher;
import java.util.function.Predicate;

public class Predicates {
    private static final String SPECIAL_CHARACTERS = "-/@#$%^&_+=()";
    public static final Predicate<String> SPECIAL_CHARS_ONLY = str -> CharMatcher.anyOf((CharSequence)SPECIAL_CHARACTERS).matchesAllOf((CharSequence)str);
    public static final Predicate<TestItem> IS_RETRY = item -> item.getRetryProcessed() != null;
    public static final Predicate<TestItem> ITEM_CAN_BE_INDEXED = testItem -> testItem != null && testItem.getIssue() != null && !TestItemIssueType.TO_INVESTIGATE.getLocator().equals(testItem.getIssue().getIssueType()) && !testItem.getIssue().isIgnoreAnalyzer();
    public static final Predicate<Launch> LAUNCH_CAN_BE_INDEXED = launch -> launch != null && Mode.DEFAULT.equals((Object)launch.getMode());

    private Predicates() {
    }
}

