/*
 * Decompiled with CFR 0.152.
 */
package com.epam.ta.reportportal.info;

import com.epam.ta.reportportal.info.ExtensionContributor;
import com.google.common.collect.ImmutableMap;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import java.util.stream.Collectors;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.cloud.client.discovery.DiscoveryClient;
import org.springframework.stereotype.Component;

@Component
public class AnalyzerInfoContributor
implements ExtensionContributor {
    private static final String ANALYZER_KEY = "analyzer";
    private final DiscoveryClient discoveryClient;

    @Autowired
    public AnalyzerInfoContributor(DiscoveryClient discoveryClient) {
        this.discoveryClient = discoveryClient;
    }

    public Map<String, ?> contribute() {
        Set collect = this.discoveryClient.getServices().stream().flatMap(service -> this.discoveryClient.getInstances(service).stream()).filter(instance -> instance.getMetadata().containsKey(ANALYZER_KEY)).map(instance -> (String)instance.getMetadata().get(ANALYZER_KEY)).collect(Collectors.toCollection(TreeSet::new));
        return ImmutableMap.builder().put((Object)ANALYZER_KEY, (Object)collect).build();
    }
}

