/*
 * Decompiled with CFR 0.152.
 */
package com.epam.ta.reportportal.demo_data;

import com.epam.ta.reportportal.database.entity.item.issue.TestItemIssue;
import com.epam.ta.reportportal.exception.ReportPortalException;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Range;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.nio.charset.StandardCharsets;
import java.util.List;
import java.util.Set;
import java.util.SplittableRandom;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import org.springframework.core.io.ClassPathResource;

/*
 * Exception performing whole class analysis ignored.
 */
final class ContentUtils {
    private static final int MAX_ERROR_LOGS_COUNT = 2;
    private static final int ERRORS_COUNT = 9;
    private static final Range<Integer> PROBABILITY_RANGE = Range.openClosed((Comparable)Integer.valueOf(0), (Comparable)Integer.valueOf(100));
    private static SplittableRandom random = new SplittableRandom();

    private ContentUtils() {
    }

    static Set<String> getTagsInRange(int limit) {
        List content = ContentUtils.readToList((String)"demo/content/tags.txt");
        int fromIndex = random.nextInt(content.size() - limit);
        return ImmutableSet.builder().addAll(content.subList(fromIndex, fromIndex + limit)).build();
    }

    static String getSuiteDescription() {
        List content = ContentUtils.readToList((String)"demo/content/suite-description.txt");
        return (String)content.get(random.nextInt(content.size()));
    }

    static String getStepDescription() {
        List content = ContentUtils.readToList((String)"demo/content/step-description.txt");
        return (String)content.get(random.nextInt(content.size()));
    }

    static String getTestDescription() {
        List content = ContentUtils.readToList((String)"demo/content/test-description.txt");
        return (String)content.get(random.nextInt(content.size()));
    }

    static String getDefectDescription(String issueType) {
        List content = ContentUtils.readToList((String)"demo/content/defects.txt");
        return (String)content.get(random.nextInt(content.size()));
    }

    static String getLaunchDescription() {
        return ContentUtils.readToString((String)"demo/content/description.txt");
    }

    static List<String> getErrorLogs() {
        return IntStream.range(0, 2).mapToObj(i -> {
            int errorNumber = random.nextInt(1, 9);
            return ContentUtils.readToString((String)("demo/errors/" + errorNumber + ".txt"));
        }).collect(Collectors.toList());
    }

    static String getLogMessage() {
        List logs = ContentUtils.readToList((String)"demo/content/demo_logs.txt");
        return (String)logs.get(random.nextInt(logs.size()));
    }

    static boolean getWithProbability(int probability) {
        Preconditions.checkArgument((boolean)PROBABILITY_RANGE.contains((Comparable)Integer.valueOf(probability)), (String)"%s is not in range [%s]", (int)probability, (Object)PROBABILITY_RANGE);
        return Range.closedOpen((Comparable)PROBABILITY_RANGE.lowerEndpoint(), (Comparable)Integer.valueOf(probability)).contains((Comparable)Integer.valueOf(random.nextInt((Integer)PROBABILITY_RANGE.upperEndpoint())));
    }

    static TestItemIssue getProductBug() {
        return new TestItemIssue("PB001", ContentUtils.bugDescription((String)"demo/content/comments/product.txt"));
    }

    static TestItemIssue getAutomationBug() {
        return new TestItemIssue("AB001", ContentUtils.bugDescription((String)"demo/content/comments/automation.txt"));
    }

    static TestItemIssue getSystemIssue() {
        return new TestItemIssue("SI001", ContentUtils.bugDescription((String)"demo/content/comments/system.txt"));
    }

    static TestItemIssue getInvestigate() {
        return new TestItemIssue("TI001", ContentUtils.bugDescription((String)"demo/content/comments/investigate.txt"));
    }

    private static String bugDescription(String resource) {
        String description = null;
        if (random.nextBoolean()) {
            List descriptions = ContentUtils.readToList((String)resource);
            description = (String)descriptions.get(random.nextInt(descriptions.size()));
        }
        return description;
    }

    private static List<String> readToList(String resource) {
        List<String> content;
        try (BufferedReader reader = new BufferedReader(new InputStreamReader(new ClassPathResource(resource).getInputStream(), StandardCharsets.UTF_8));){
            content = reader.lines().collect(Collectors.toList());
        }
        catch (IOException e) {
            throw new ReportPortalException("Missing demo content.", (Throwable)e);
        }
        return content;
    }

    private static String readToString(String resource) {
        String content;
        try (BufferedReader reader = new BufferedReader(new InputStreamReader(new ClassPathResource(resource).getInputStream(), StandardCharsets.UTF_8));){
            content = reader.lines().collect(Collectors.joining("\n"));
        }
        catch (IOException e) {
            throw new ReportPortalException("Missing demo content.", (Throwable)e);
        }
        return content;
    }
}

