/*
 * Decompiled with CFR 0.152.
 */
package com.epam.ta.reportportal.core.widget.impl;

import com.epam.ta.reportportal.commons.Predicates;
import com.epam.ta.reportportal.commons.validation.BusinessRule;
import com.epam.ta.reportportal.commons.validation.Suppliers;
import com.epam.ta.reportportal.core.widget.content.GadgetTypes;
import com.epam.ta.reportportal.core.widget.content.WidgetDataTypes;
import com.epam.ta.reportportal.database.entity.Launch;
import com.epam.ta.reportportal.database.entity.filter.UserFilter;
import com.epam.ta.reportportal.database.entity.item.Activity;
import com.epam.ta.reportportal.database.entity.item.TestItem;
import com.epam.ta.reportportal.database.entity.widget.Widget;
import com.epam.ta.reportportal.database.search.CriteriaMap;
import com.epam.ta.reportportal.ws.model.ErrorType;
import com.google.common.collect.ImmutableMap;
import java.util.List;
import java.util.Map;
import java.util.function.Predicate;
import org.springframework.data.domain.Sort;

public class WidgetUtils {
    public static final String NAME = "name";
    public static final String NUMBER = "number";
    public static final String START_TIME = "start_time";
    public static final String USER = "user";
    public static final Map<GadgetTypes, Class<?>> withoutFilter = ImmutableMap.builder().put((Object)GadgetTypes.PRODUCT_STATUS, Launch.class).put((Object)GadgetTypes.ACTIVITY, Activity.class).put((Object)GadgetTypes.PASSING_RATE_PER_LAUNCH, Launch.class).put((Object)GadgetTypes.MOST_FAILED_TEST_CASES, TestItem.class).put((Object)GadgetTypes.FLAKY_TEST_CASES, TestItem.class).build();

    private WidgetUtils() {
    }

    public static void validateFields(Iterable<String> fields, CriteriaMap<?> criteriaMap, ErrorType errorType) {
        if (fields == null || criteriaMap == null || errorType == null) {
            return;
        }
        fields.forEach(field -> BusinessRule.expect((Object)criteriaMap.getCriteriaHolderUnchecked(field).isPresent(), (Predicate)Predicates.equalTo((Object)true)).verify(errorType, new Object[]{Suppliers.formattedSupplier((String)"Field '{}' cannot be used for calculating data for widget.", (Object[])new Object[]{field})}));
    }

    public static void validateWidgetDataType(String type, ErrorType errorType) {
        BusinessRule.expect((Object)WidgetDataTypes.findByName((String)type).isPresent(), (Predicate)Predicates.equalTo((Object)true)).verify(errorType, new Object[]{Suppliers.formattedSupplier((String)"Unknown widget data type: '{}'. Possible data types: line_chart, bar_chart, column_chart, combine_pie_chart, table", (Object[])new Object[]{type})});
    }

    public static void validateGadgetType(String gadget, ErrorType errorType) {
        BusinessRule.expect((Object)GadgetTypes.findByName((String)gadget).isPresent(), (Predicate)Predicates.equalTo((Object)true)).verify(errorType, new Object[]{Suppliers.formattedSupplier((String)"Unknown gadget type: '{}'.", (Object[])new Object[]{gadget})});
    }

    public static void checkApplyingFilter(UserFilter filter, String filterID, String userName) {
        BusinessRule.expect((Object)filter, (Predicate)Predicates.notNull()).verify(ErrorType.USER_FILTER_NOT_FOUND, new Object[]{filterID, userName});
        BusinessRule.expect((Object)filter.isLink(), (Predicate)Predicates.equalTo((Object)false)).verify(ErrorType.UNABLE_TO_CREATE_WIDGET, new Object[]{"Cannot create widget based on a link."});
    }

    public static void checkUniqueName(String newWidgetName, List<Widget> existingWidgets) {
        if (null != existingWidgets) {
            existingWidgets.forEach(existingWidget -> BusinessRule.expect((Object)existingWidget.getName().equals(newWidgetName), (Predicate)Predicates.equalTo((Object)false)).verify(ErrorType.RESOURCE_ALREADY_EXISTS, new Object[]{newWidgetName}));
        }
    }

    public static boolean needRevert(Sort sort) {
        if (sort == null) {
            return false;
        }
        String property = ((Sort.Order)sort.iterator().next()).getProperty();
        Sort.Order orderFor = sort.getOrderFor(property);
        return property.equalsIgnoreCase(START_TIME) && orderFor.isDescending();
    }
}

