/*
 * Decompiled with CFR 0.152.
 */
package com.epam.ta.reportportal.core.widget.impl;

import com.epam.ta.reportportal.core.acl.AclUtils;
import com.epam.ta.reportportal.core.acl.SharingService;
import com.epam.ta.reportportal.core.widget.ICreateWidgetHandler;
import com.epam.ta.reportportal.core.widget.content.GadgetTypes;
import com.epam.ta.reportportal.core.widget.impl.WidgetUtils;
import com.epam.ta.reportportal.database.dao.UserFilterRepository;
import com.epam.ta.reportportal.database.dao.WidgetRepository;
import com.epam.ta.reportportal.database.entity.filter.UserFilter;
import com.epam.ta.reportportal.database.entity.item.TestItem;
import com.epam.ta.reportportal.database.entity.sharing.Acl;
import com.epam.ta.reportportal.database.entity.widget.Widget;
import com.epam.ta.reportportal.database.search.CriteriaMap;
import com.epam.ta.reportportal.database.search.CriteriaMapFactory;
import com.epam.ta.reportportal.events.WidgetCreatedEvent;
import com.epam.ta.reportportal.ws.converter.builders.WidgetBuilder;
import com.epam.ta.reportportal.ws.model.EntryCreatedRS;
import com.epam.ta.reportportal.ws.model.ErrorType;
import com.epam.ta.reportportal.ws.model.widget.ContentParameters;
import com.epam.ta.reportportal.ws.model.widget.WidgetRQ;
import com.google.common.collect.Lists;
import java.util.List;
import javax.annotation.Resource;
import javax.inject.Provider;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.ApplicationEventPublisher;
import org.springframework.stereotype.Service;

@Service
@Resource
public class CreateWidgetHandler
implements ICreateWidgetHandler {
    private WidgetRepository widgetRepository;
    private Provider<WidgetBuilder> widgetBuilder;
    private UserFilterRepository filterRepository;
    private CriteriaMapFactory criteriaMapFactory;
    private SharingService sharingService;
    private ApplicationEventPublisher eventPublisher;

    @Autowired
    public void setWidgetRepository(WidgetRepository widgetRepository) {
        this.widgetRepository = widgetRepository;
    }

    @Autowired
    public void setEventPublisher(ApplicationEventPublisher eventPublisher) {
        this.eventPublisher = eventPublisher;
    }

    @Autowired
    public void setWidgetBuilder(Provider<WidgetBuilder> widgetBuilder) {
        this.widgetBuilder = widgetBuilder;
    }

    @Autowired
    public void setUserFilterRepository(UserFilterRepository userFilterRepository) {
        this.filterRepository = userFilterRepository;
    }

    @Autowired
    public void setCriteriaMapFactory(CriteriaMapFactory criteriaMapFactory) {
        this.criteriaMapFactory = criteriaMapFactory;
    }

    @Autowired
    public void setSharingService(SharingService sharingService) {
        this.sharingService = sharingService;
    }

    public EntryCreatedRS createWidget(WidgetRQ createWidgetRQ, String projectName, String userName) {
        List widgetList = this.widgetRepository.findByProjectAndUser(projectName, userName);
        WidgetUtils.checkUniqueName((String)createWidgetRQ.getName(), (List)widgetList);
        String widgetType = createWidgetRQ.getContentParameters().getType();
        String gadgetType = createWidgetRQ.getContentParameters().getGadget();
        WidgetUtils.validateWidgetDataType((String)widgetType, (ErrorType)ErrorType.BAD_SAVE_WIDGET_REQUEST);
        WidgetUtils.validateGadgetType((String)gadgetType, (ErrorType)ErrorType.BAD_SAVE_WIDGET_REQUEST);
        Widget widget = this.create(createWidgetRQ, projectName, userName);
        this.widgetRepository.save((Object)widget);
        this.eventPublisher.publishEvent((Object)new WidgetCreatedEvent(createWidgetRQ, userName, projectName, widget.getId()));
        return new EntryCreatedRS(widget.getId());
    }

    private Widget create(WidgetRQ createWidgetRQ, String projectName, String userName) {
        GadgetTypes gadget = (GadgetTypes)GadgetTypes.findByName((String)createWidgetRQ.getContentParameters().getGadget()).get();
        UserFilter filter = null;
        if (!WidgetUtils.withoutFilter.containsKey(gadget)) {
            filter = this.filterRepository.findOneLoadACL(userName, createWidgetRQ.getFilterId(), projectName);
            WidgetUtils.checkApplyingFilter((UserFilter)filter, (String)createWidgetRQ.getFilterId(), (String)userName);
        }
        this.clearContentParameters(createWidgetRQ.getContentParameters(), filter);
        this.validateContentParameters(createWidgetRQ.getContentParameters(), filter, gadget);
        Widget widget = (Widget)((WidgetBuilder)this.widgetBuilder.get()).addWidgetRQ(createWidgetRQ).addFilter(createWidgetRQ.getFilterId()).addProject(projectName).addSharing(userName, projectName, createWidgetRQ.getDescription(), createWidgetRQ.getShare() == null ? false : createWidgetRQ.getShare()).build();
        this.shareIfRequired(createWidgetRQ.getShare(), widget, userName, projectName, filter);
        return widget;
    }

    private void shareIfRequired(Boolean isShare, Widget widget, String userName, String projectName, UserFilter filter) {
        if (isShare != null) {
            if (null != filter) {
                AclUtils.isPossibleToRead((Acl)filter.getAcl(), (String)userName, (String)projectName);
            }
            this.sharingService.modifySharing((List)Lists.newArrayList((Object[])new Widget[]{widget}), userName, projectName, isShare.booleanValue());
        }
    }

    private void clearContentParameters(ContentParameters contentParameters, UserFilter filter) {
        if (null != contentParameters.getMetadataFields() && (null == filter || filter.getFilter().getTarget().equals(TestItem.class)) && contentParameters.getMetadataFields().contains("number")) {
            contentParameters.getMetadataFields().remove("number");
        }
        if (null != contentParameters.getContentFields() && (null == filter || filter.getFilter().getTarget().equals(TestItem.class))) {
            if (contentParameters.getContentFields().contains("number")) {
                contentParameters.getContentFields().remove("number");
            }
            if (contentParameters.getContentFields().contains("user")) {
                contentParameters.getContentFields().remove("user");
            }
        }
    }

    private void validateContentParameters(ContentParameters contentParameters, UserFilter filter, GadgetTypes gadget) {
        Class filterTarget = WidgetUtils.withoutFilter.containsKey(gadget) ? (Class)WidgetUtils.withoutFilter.get(gadget) : filter.getFilter().getTarget();
        CriteriaMap criteriaMap = this.criteriaMapFactory.getCriteriaMap(filterTarget);
        if (null != contentParameters.getContentFields()) {
            WidgetUtils.validateFields((Iterable)contentParameters.getContentFields(), (CriteriaMap)criteriaMap, (ErrorType)ErrorType.BAD_SAVE_WIDGET_REQUEST);
        }
        if (null != contentParameters.getMetadataFields()) {
            WidgetUtils.validateFields((Iterable)contentParameters.getMetadataFields(), (CriteriaMap)criteriaMap, (ErrorType)ErrorType.BAD_SAVE_WIDGET_REQUEST);
        }
    }
}

