/*
 * Decompiled with CFR 0.152.
 */
package com.epam.ta.reportportal.core.widget.content;

import com.epam.ta.reportportal.commons.Predicates;
import com.epam.ta.reportportal.commons.validation.BusinessRule;
import com.epam.ta.reportportal.core.widget.content.IContentLoadingStrategy;
import com.epam.ta.reportportal.core.widget.content.StatisticBasedContentLoader;
import com.epam.ta.reportportal.core.widget.impl.WidgetUtils;
import com.epam.ta.reportportal.database.StatisticsDocumentHandler;
import com.epam.ta.reportportal.database.dao.LaunchRepository;
import com.epam.ta.reportportal.database.search.Filter;
import com.epam.ta.reportportal.database.search.Queryable;
import com.epam.ta.reportportal.ws.model.ErrorType;
import com.epam.ta.reportportal.ws.model.widget.ChartObject;
import com.google.common.collect.ImmutableList;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.text.DecimalFormat;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Predicate;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Sort;
import org.springframework.data.mongodb.core.DocumentCallbackHandler;
import org.springframework.stereotype.Service;

/*
 * Exception performing whole class analysis ignored.
 */
@Service(value="NotPassedTestsContentLoader")
public class NotPassedTestsContentLoader
extends StatisticBasedContentLoader
implements IContentLoadingStrategy {
    private static final String NOT_PASSED_PERCENT = "% (Failed+Skipped)/Total";
    @Autowired
    private LaunchRepository launchRepository;

    @SuppressFBWarnings(value={"NP_NULL_PARAM_DEREF"})
    public Map<String, List<ChartObject>> loadContent(String projectName, Filter filter, Sort sorting, int quantity, List<String> contentFields, List<String> metaDataFields, Map<String, List<String>> options) {
        BusinessRule.expect((Object)(metaDataFields == null || metaDataFields.isEmpty() ? 1 : 0), (Predicate)Predicates.equalTo((Object)Boolean.FALSE)).verify(ErrorType.UNABLE_LOAD_WIDGET_CONTENT, new Object[]{"Metadata fields should exist for providing content for 'column chart'."});
        ImmutableList allFields = ImmutableList.builder().addAll(contentFields).addAll(metaDataFields).build();
        StatisticsDocumentHandler handler = new StatisticsDocumentHandler(contentFields, metaDataFields);
        String collectionName = NotPassedTestsContentLoader.getCollectionName((Class)filter.getTarget());
        if (options.containsKey("latest")) {
            this.launchRepository.findLatestWithCallback((Queryable)filter, sorting, (List)allFields, (long)quantity, (DocumentCallbackHandler)handler);
        } else {
            this.launchRepository.loadWithCallback((Queryable)filter, sorting, quantity, (List)allFields, (DocumentCallbackHandler)handler, collectionName);
        }
        return this.convertResult(handler, sorting);
    }

    private Map<String, List<ChartObject>> convertResult(StatisticsDocumentHandler handler, Sort sort) {
        DecimalFormat formatter = new DecimalFormat("###.##");
        List objects = handler.getResult();
        if (objects.isEmpty()) {
            return Collections.emptyMap();
        }
        if (WidgetUtils.needRevert((Sort)sort)) {
            Collections.reverse(objects);
        }
        for (ChartObject object : objects) {
            HashMap<String, String> values = new HashMap<String, String>();
            double failed = Integer.parseInt((String)object.getValues().get(this.getFailedFieldName()));
            double skipped = Integer.parseInt((String)object.getValues().get(this.getSkippedFieldName()));
            double total = Integer.parseInt((String)object.getValues().get(this.getTotalFieldName()));
            if (total > 0.0) {
                double percent = (failed + skipped) / total * 100.0;
                values.put("% (Failed+Skipped)/Total", formatter.format(percent));
            } else {
                values.put("% (Failed+Skipped)/Total", "0");
            }
            object.setValues(values);
        }
        return Collections.singletonMap("result", objects);
    }
}

