/*
 * Decompiled with CFR 0.152.
 */
package com.epam.ta.reportportal.core.preference.impl;

import com.epam.ta.reportportal.commons.Predicates;
import com.epam.ta.reportportal.commons.validation.BusinessRule;
import com.epam.ta.reportportal.core.preference.IGetPreferenceHandler;
import com.epam.ta.reportportal.database.dao.ProjectRepository;
import com.epam.ta.reportportal.database.dao.UserPreferenceRepository;
import com.epam.ta.reportportal.database.entity.UserPreference;
import com.epam.ta.reportportal.ws.converter.UserPreferenceResourceAssembler;
import com.epam.ta.reportportal.ws.model.ErrorType;
import com.epam.ta.reportportal.ws.model.preference.PreferenceResource;
import java.util.function.Predicate;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class GetPreferenceHandler
implements IGetPreferenceHandler {
    @Autowired
    private UserPreferenceRepository userPreferenceRepository;
    @Autowired
    private ProjectRepository projectRepository;
    @Autowired
    private UserPreferenceResourceAssembler resourceAssembler;

    public PreferenceResource getPreference(String projectName, String userName) {
        boolean assignedToProject = this.projectRepository.isAssignedToProject(projectName, userName);
        BusinessRule.expect((Object)Boolean.TRUE, (Predicate)Predicates.equalTo((Object)assignedToProject)).verify(ErrorType.PROJECT_DOESNT_CONTAIN_USER, new Object[]{projectName, userName});
        UserPreference preference = this.userPreferenceRepository.findByProjectAndUserName(projectName, userName);
        if (null == preference) {
            preference = new UserPreference();
            preference.setUserRef(userName);
            preference.setProjectRef(projectName);
        }
        return this.resourceAssembler.toResource(preference);
    }
}

